; scripts for GoldMine 4.0
;Copyright 1999 by Henter-Joyce, Incorporated

; by D.Baker
; 2/16/99
;Revised and updated 05/13/1999 - 06/08/1999 by B. Key

include "hjconst.jsh"
include "hjglobal.jsh"
include "gmw4.jsh"
include "gmw4.jsm"
use "magGmw4.jsb"

; *** General functions to obtain or speak information about the GoldMine environment here
Void Function ResetnSuppressEcho ()
Let nSuppressEcho = FALSE
EndFunction

Int Function IsActivityListDialog ()
Var Handle fWin, Handle pWin, String fwClass, String pwClass
; If the current window is a member of the activity list dialog box, the window class of the Focus window is always gmWndBrowse and the window class of the parent window of the focus window
; is always SysTabControl32.  In order to determine if the current window is a member of the activity list dialog box, simply check for these conditions.
Let fWin = GetFocus ()
Let pWin = GetParent (fWin)
Let fwClass = GetWindowClass (fWin)
Let pwClass = GetWindowClass (pWin)
If (fwClass == WCBrowse && pwClass == wcMsTab) then Return 1 else Return 0 EndIf
EndFunction

Int Function IsInfoCenter ()
Var string AppTitle
Let AppTitle = GetAppTitle ()
; If the InfoCenter window is maximized the App Title will contain the word InfoCenter
If (StringContains (AppTitle, "InfoCenter")) then Return 1 Else
; If the InfoCenter window is in a restored state and the current control is not the Rich Edit window, the title of the real window of the current window will contain the word InfoCenter
	Let AppTitle = GetWindowName (GetRealWindow (GetCurrentWindow ()))
	If (StringContains (AppTitle, "InfoCenter")) then Return 1 Else
; If the InfoCenter window is in a restored state and the current control is the Rich Edit window, the title of the real window of the parent of the current window will contain the word InfoCenter
		Let AppTitle = GetWindowName (GetRealWindow (GetParent (GetCurrentWindow ())))
		If (StringContains (AppTitle, "InfoCenter")) then Return 1 Else Return 0 EndIf
	EndIf
EndIf
EndFunction

Int Function IsGoldMineAlarm ()
Var Handle rWin
Let rWin = GetRealWindow (GetFocus ())
; If the current window is part of the GoldMine Alarm dialog, then the real window title will always be GoldMine Alarm.
If (GetWindowName (rWin) == wnGMAlarm) then Return 1 Else Return 0 EndIf
EndFunction

Int Function IsScheduleConflictDialog ()
Var Handle rWin
Let rWin = GetRealWindow (GetFocus ())
; If the current window is part of the Schedule Conflict dialog, then the real window title will always be "Schedule Conflict!".
If (GetWindowName (rWin) == wnGMConflict) then Return 1 Else Return 0 EndIf
EndFunction

Int Function ReadActivityDetails ()
Var 
	Handle pWin, Handle eWin, 
	Int nL, Int nL1, Int nR, Int nR1, 
	Int nT, Int nB, Int nT1
; Store the window handle of the parent window of the current focus window
Let pWin = GetParent (GetFocus ())
;  Confirm that the current window is a part of the Activity List dialog box
If (IsActivityListDialog ()) then
;  Find the edit window that contains the notes pertaining to the selected activity.  It is a decendent window of the window pWin and has a control ID of 1016
	Let eWin = FindDescendantWindow (pWin, ID_ActivityDetail)
	If (eWin == 0) then
		Say (msg039, ot_message)
	Else
;  The details of the selected activity are displayed in two locations on the screen.  The first is the window eWin.  The second is a small region in the bottom left hand corner of the
;  window pWin and to the lef of the window eWin.   Create two dynamic frames surrounding these two regions and read the information they contain
		Let nL = GetWindowLeft (GetFocus ())
		Let nL1 = GetWindowLeft (eWin)
		Let nR = GetWindowRight (eWin) - 10
		Let nR1 = GetWindowLeft (eWin)
		Let nT = GetWindowTop (eWin)
		Let nB = GetWindowBottom (eWin)
		SaveCursor ()
		InvisibleCursor ()
		If (FindString (FindActivityListSysTabWindow (), strContact, S_BOTTOM, S_UNRESTRICTED)) then
			Let nT1 = GetLineTop () - 3
			If (nT1 > nT) then
			Else
				Let nT1 = nT
			EndIf
		Else
			Let nT1 = nT
		EndIf
		RestoreCursor ()		
		SayTextBetweenTwoPoints (nL, nT1, nR1, nB)
		SayTextBetweenTwoPoints (nL1, nT, nR, nB)
	EndIf
EndIf
EndFunction

Int Function IsOrgChart ()
Var String cwClass
Let cwClass = GetWindowClass (GetCurrentWindow ())
;  If the current window has a window class of SysTreeView32 and its parent window has a window class of GMOrgWnd, then the current window is the organizational chart.
If (cwClass == wcOrgChart && GetWindowClass (GetParent (GetCurrentWindow ())) == wcRecordSecondChild) then
	Return 1
Else Return 0 EndIf
EndFunction

Int Function IsRecordViewVisible ()
Var String cwClass, String pwClass, String gpwClass, Handle cwWin, Handle pwWin, Handle gpwWin
;  If the record view is visible, then one of the following conditions will be true:
;  1.  The current window class is GMRecord and the window class of its parent is MDIClient.
;  2.  The current window class is GMEDITOR and the window class of its parent is GMRecord.
;  3.  The window class of the parent of the current window is GMRecord and the window class of its parent is MDIClient.
;  4.  The window class of the parent of the current window is GMOrgWnd and the window class of its parent is GMRecord.
Let cwWin = GetCurrentWindow ()
Let pwWin = GetParent (cwWin)
Let gpwWin = GetParent (pwWin)
Let cwClass = GetWindowClass (cwWin)
Let pwClass = GetWindowClass (pwWin)
Let gpwClass = GetWindowClass (gpwWin)
If (cwClass == wcRecord && pwClass == wcRecordParent) then Return 1
ElIf (cwClass == wcNotes && pwClass == wcRecord) then Return 1
ElIf (pwClass == wcRecord && gpwClass == wcRecordParent) then Return 1
ElIf (pwClass == wcRecordSecondChild && gpwClass == wcRecord) then Return 1
Else Return 0 EndIf
EndFunction

Void Function SayTextBetweenTwoPoints (int nLeft, int nTop, int nRight, int nBottom)
;  This function is used to say the text between two points defined by both X and Y coordinates.  This function is more powerful than
;  SayTextBetween in that it can be used to say the text contained in a rectangular area, as opposed to saying the text located on a
;  single line between a left and right edge.
Var Int nOrigSetting
Let nOrigSetting = GetJcfOption (OPT_INCLUDE_GRAPHICS)
SetJcfOption (OPT_INCLUDE_GRAPHICS, 0)
SaveCursor ()
InvisibleCursor ()
;  Move the invisible cursor to the top left hand corner of the rectangular region of interest.
MoveTo (nLeft, nTop)
; Say the text between the left and right edges of the rectangular region on the current line and move down one line until reaching the bottom of the region of interest
While (GetCursorRow () <= nBottom)
	SayTextBetween (nLeft, nRight)
	NextLine ()
EndWhile
; Restore the cursor that was active before the function was called
RestoreCursor ()
SetJcfOption (OPT_INCLUDE_GRAPHICS, nOrigSetting)
EndFunction

Int Function GetBottomOfPageTabs ()
Var String fwClass, Int nPos
Let fwClass = GetWindowClass (GetFocus ())
SaveCursor ()
If !(fwClass == wcRecord || fwClass == wcBrowse || fwClass == wcNotes) then Return EndIf
If (fwClass == wcRecord || fwClass == wcBrowse || fwClass == wcNotes) then
	;  This function is only called when the Summary page tab is visible.  Therefore find the first occurance of the word summary from the bottom of the screen and return the Cursor Row position
	;  of that point.
	If (FindString (FindRecordWindow (), SummaryPage, S_BOTTOM, S_UNRESTRICTED)) then
		Let nPos = GetCursorRow () + 5
	Else Let nPos = 0
	EndIf
EndIf
RestoreCursor ()
Return nPos
EndFunction

Void Function SayRecordIdentifier ()
Var String strTitle,  String strIdentifier, Handle hAppWin, Handle rWin
; Store the window handles of the Application main window and the real window
Let hAppWin = GetAppMainWindow (GetCurrentWindow ())
Let rWin = GetRealWindow (GetCurrentWindow ())
;  First get the application title, since if the record view window is maximized, the record identifier will be displayed in the title bar of the application main window
Let strTitle = GetWindowName (hAppWin)
; If the application window title contains a [, then use string segment to seperate the record identifier from the rest of the app title
If (StringContains (strTitle, "[")) then
	Let strIdentifier = StringSegment (strTitle, "[", 2)
	Let strIdentifier = StringSegment (strIdentifier, "]", 1)
Else
;  If the record view window is in a restored state, the record identifier will be displayed in the window title of the real window instead.
	Let strIdentifier = GetWindowName (rWin)
EndIf
; Say the record identifier
Say (strIdentifier, ot_message)
EndFunction

String Function GetFieldLabel ()
; Useful for for the string comparison of field labels
Var handle hwnd, string TheClass, string sLabel, string strTest
let hwnd = GetFocus ()
let TheClass = GetWindowClass (hwnd)
If (TheClass == WCField) then
; under most circumstances, the current window name is the field label when in edit record mode
	let sLabel = GetWindowName (hwnd)
	; Verify the field label returned by get window name.  This is especially necessary for the Address Line 1 field that has no text label and for the four fields labeled Ext:
	SaveCursor ()
	RouteInvisibleToPc ()
	InvisibleCursor ()
	PriorWord ()
	Let strTest = GetWord ()
	If (strTest == msg004) then
		PriorLine ()
		Let strTest = GetLine ()
		If (StringContains (strTest, msg005)) then Let sLabel = msg006 EndIf
	ElIf (strTest == msg007) then
		let strTest = GetLine ()
		If (StringContains (strTest, msg008)) then Let sLabel = msg009
			ElIf (StringContains (strTest, msg010)) then Let sLabel = msg011
			ElIf (StringContains (strTest, msg012)) then Let sLabel = msg013
			ElIf (StringContains (strTest, msg014)) then Let sLabel = msg015 EndIf
	EndIf
	RestoreCursor ()
 ; Verify the field label returned by get window name.  This is especially necessary for the Address Line 1 field that has no text label
	Return sLabel
EndIf
EndFunction

String Function GetAllToolBarWindows (int ByRef nCount)
Var Handle StartWin, Handle hTest, Handle tmpHandle,
	Handle tmpHandleA, String strHandle, String strHandleList,
	Handle hChild
Let strHandleList = ""
Let nCount = 0
Let StartWin = GetAppMainWindow (GetFocus ())
Let hTest = GetFirstChild (StartWin)
; Get the window handle of the first ATC_DockWindow by walking through the window 
;	hierarchy until finding a window with a class of ATC_DockWindow.
While (hTest != 0	&& GetWindowClass (hTest) != wcToolBarParent) 
	Let hTest = GetNextWindow (hTest)
EndWhile
;  Set tmpHandle equal to the window handle of the first ATC_DockWindow window found
Let tmpHandle = hTest
;	Walk through all of the ATC_DockWindow windows and determine if they have any child windows.
While (tmpHandle && GetWindowClass (tmpHandle) == wcToolBarParent)
	Let hChild = GetFirstChild (tmpHandle)
	;	If a child window is found, then it is the parent window of at least one tool bar.
	;	Walk through the next level of the window hierarchy and add all the window handles
	;	of the tool bars that are found to a delimited list.  Also, update the value of
	;	nCount for each window found.
	If (hChild != 0) then
		Let tmpHandleA = hChild
		While (tmpHandleA && GetWindowClass (tmpHandleA) == wcTool_Bar)
			Let strHandle = IntToString (tmpHandleA)
			If (IsWindowVisible (tmpHandleA)) then
				Let strHandleList = strHandleList + strHandle + "\007"
				Let nCount = nCount + 1
			EndIf
			Let tmpHandleA = GetNextWindow (tmpHandleA)
		EndWhile
	EndIf
	Let tmpHandle = GetNextWindow (tmpHandle)
EndWhile
Return strHandleList
EndFunction

String Function FindAllWindowsWithClass (handle StartWin, string strWinClass, Int ByRef nCount)
Var Handle tmpHandle, String strHandle, String strHandleList, String tmpClass, Int nSafety, Int nSafetyA, Int nSafetyB, Handle hChild,
	Handle tmpHandleA, Handle tmpHandleB
Let nSafety = 0
Let strHandleList = ""
Let tmpHandle = StartWin
;  This function walks through the first three levels of windows below the specified start window and returns a verticle bar delimited list of all the window handles of window with the specified class

; Level 1
While (tmpHandle && nSafety < 50)
	Let strHandle = IntToString (tmpHandle)
	Let tmpClass = GetWindowClass (tmpHandle)
	If (tmpClass ==  strWinClass) then
		If (IsWindowVisible (tmpHandle)) then
			Let strHandleList = strHandleList + strHandle + "\007"
			Let nCount = nCount + 1 EndIf
		EndIf
	; Handle second level of windows below
	Let hChild = GetFirstChild (tmpHandle)
	;  If a child window is found, step down into levels 2 and 3
	If (hChild != 0) then
		Let nSafetyA = 0
		Let tmpHandleA = hChild
		While (tmpHandleA && nSafetyA < 50)
			Let strHandle = IntToString (tmpHandleA)
			Let tmpClass = GetWindowClass (tmpHandleA)
			If (tmpClass ==  strWinClass) then
				If (IsWindowVisible (tmpHandleA)) then
					Let strHandleList = strHandleList + strHandle + "\007"
					Let nCount = nCount + 1
				EndIf
			EndIf
			; Handle third level of windows below
			Let hChild = GetFirstChild (tmpHandleA)
		  ;  If a child window is found, step down into level 3
			If (hChild != 0) then
				Let nSafetyB = 0
				Let tmpHandleB = hChild
				While (tmpHandleB && nSafety <50)
					 Let strHandle = IntToString (tmpHandleB)
					 Let tmpClass = GetWindowClass (tmpHandleB)
					 If (tmpClass ==  strWinClass) then
						 If (IsWindowVisible (tmpHandleB)) then
							 Let strHandleList = strHandleList + strHandle + "\007"
							 Let nCount = nCount + 1
						 EndIf
					 EndIf
					 Let tmpHandleB = GetNextWindow (tmpHandleB)
					 Let nSafetyB = nSafetyB + 1
				EndWhile
			EndIf
			; Handle third level of windows above
			Let tmpHandleA = GetNextWindow (tmpHandleA)
			Let nSafetyA = nSafetyA + 1
		EndWhile
	EndIf
	; Handle second level of windows above
	Let tmpHandle = GetNextWindow (tmpHandle)
	Let nSafety = nSafety + 1
EndWhile
Return strHandleList
EndFunction

HANDLE Function FindFirstWindowWithClass (handle StartWin, string strWinClass)
Var Handle tmpHandle, String tmpClass, Int nSafety
Let nSafety = 0
; Determine the window class of StartWin
Let tmpClass = GetWindowClass (StartWin)
; If the window class of StartWin is not equal to the specified window class, enter the while loop and step through the window
; heirchy until finding a window of the specified window class or until no next version can be found.  Using this algorithm, a
; window of the specified class will only be found if it is on the same logical level as the start window.  Once a window has been
; found with the specified class, return the window handle of the window.
If (tmpClass ==  strWinClass) then Return StartWin Else
	; Initialize the variable tmpHandle prior to entering the while loop
	Let tmpHandle = StartWin
	While (tmpClass != strWinClass && nSafety < 50)
		Let tmpHandle = GetNextWindow (tmpHandle)
		Let tmpClass = GetWindowClass (tmpHandle)
		If (tmpClass ==  strWinClass) then Return tmpHandle EndIf
		Let nSafety = nSafety + 1
	EndWhile
EndIf
If (tmpHandle == StartWin) then Return 0 EndIf
EndFunction

HANDLE Function FindBrowseWindow ()
Var Handle AppWin, Handle hMDI, Handle hRecord, Handle hBrowse
; Return without any further processing if the Record View window is not visible
If (IsRecordViewVisible () == 0) then Return 0 EndIf
;  Walk down the window heirarchy searching for a window with a window class of gmWndBrowse.  If the window is present, it will be one
;  of the great grandchildren of the main application window.  Its parent window will have a window class of GMRecord and its grand
;  parent window will have a window class of MDIClient

; Obtain the window handle of the application main window.  This window handle will be used as a starting point for the search
; through the window heirarchy
Let AppWin = GetAppMainWindow (GetFocus ())
;  Find the first child wiundow of the application main window that has a window class of MDIClient.  Store the handle of the
;  window in hMDI.
Let hMDI = FindFirstWindowWithClass (GetFirstChild (AppWin), wcRecordParent)
;  Find the first child window of hMDI that has a window class of GMRecord.  Store the handle of the
;  window in hRecord.
Let hRecord = FindFirstWindowWithClass (GetFirstChild (hMDI), wcRecord)
;  Find the first child window of hRecord that has a window class of gmWndBrowse.  Store its handle in a variable and return the
;  window handle found.  If no window is found, the return value will be 0.
Let hBrowse = FindFirstWindowWithClass (GetFirstChild (hRecord), wcBrowse)
Return hBrowse
EndFunction


HANDLE Function FindActivityListSysTabWindow ()
Var Handle hAppWin, Handle hFirstChild, 
	Handle hGmActvObj, Handle hTarget
If (IsActivityListDialog () == 0) then
	Return 0
EndIf
Let hAppWin = GetAppMainWindow (GetFocus ())
If (hAppWin) then
	Let hFirstChild = GetFirstChild (hAppWin)
Else
	Return 0
EndIf
If (hFirstChild) then
	Let hGmActvObj = GetFirstChild (hFirstChild)
Else
	Return 0
EndIf
If (hGmActvObj) then
	Let hTarget = GetFirstChild (hGmActvObj)
Else
	Return 0
EndIf
If (hTarget) then
	Return hTarget
Else
	Return 0
EndIf
EndFunction


HANDLE Function FindNotesWindow ()
Var Handle AppWin, Handle hMDI, Handle hRecord, Handle hNotes
; Return without any further processing if the Record View window is not visible
If (IsRecordViewVisible () == 0) then Return 0 EndIf
;  Walk down the window heirarchy searching for a window with a window class of GMEDITOR.  If the window is present, it will be one
;  of the great grandchildren of the main application window.  Its parent window will have a window class of GMRecord and its grand
;  parent window will have a window class of MDIClient

; Obtain the window handle of the application main window.  This window handle will be used as a starting point for the search
; through the window heirarchy
Let AppWin = GetAppMainWindow (GetFocus ())
;  Find the first child wiundow of the application main window that has a window class of MDIClient.  Store the handle of the
;  window in hMDI.
Let hMDI = FindFirstWindowWithClass (GetFirstChild (AppWin), wcRecordParent)
;  Find the first child window of hMDI that has a window class of GMRecord.  Store the handle of the
;  window in hRecord.
Let hRecord = FindFirstWindowWithClass (GetFirstChild (hMDI), wcRecord)
;  Find the first child window of hRecord that has a window class of GMEDITOR.  Store its handle in a variable and return the
;  window handle found.  If no window is found, the return value will be 0.
Let hNotes = FindFirstWindowWithClass (GetFirstChild (hRecord), wcNotes)
Return hNotes
EndFunction

HANDLE Function FindRecordWindow ()
Var Handle AppWin, Handle hMDI, Handle hRecord
; Return without any further processing if the Record View window is not visible
If (IsRecordViewVisible () == 0) then Return 0 EndIf
;  Walk down the window heirarchy searching for a window with a window class of GMEDITOR.  If the window is present, it will be one
;  of the great grandchildren of the main application window.  Its parent window will have a window class of GMRecord and its grand
;  parent window will have a window class of MDIClient

; Obtain the window handle of the application main window.  This window handle will be used as a starting point for the search
; through the window heirarchy
Let AppWin = GetAppMainWindow (GetFocus ())
;  Find the first child wiundow of the application main window that has a window class of MDIClient.  Store the handle of the
;  window in hMDI.
Let hMDI = FindFirstWindowWithClass (GetFirstChild (AppWin), wcRecordParent)
;  Find the first child window of hMDI that has a window class of GMRecord.  Store the handle of the
;  window in hRecord.
Let hRecord = FindFirstWindowWithClass (GetFirstChild (hMDI), wcRecord)
;  Return the value of hRecord
Return hRecord
EndFunction

String Function GetInfoCenterPageList (handle ByRef MSTabHandle)
Var Handle appWin, Handle hMDI, Handle hInfo, Handle hDialog, Handle hTab, String PageList, String PageListTemp, String strTemp, String strTempA, Int pos, Int nLength
If (IsInfoCenter () == 0) then Return EndIf
;  This function is used to obtain a list of available pages in GoldMine InfoCenter.  It also returs the window handle of the InfoCenter
;  SysTabControl32 window, the parent window of the InfoCenter pages.   The function first moves down through the window hierarchy
;  to find the SysTabControl32 window (App Main Window -> MDIClient Window -> InfoObj -> #32770 -> SysTabControl32).  Then the
;  function moves the JAWS Cursor to the top left corner of the window, and gets the text of the current line.  This line is the
;  line where the various page tabs of GoldMine InfoCenter are displayed on the screen.
Let appWin = GetAppMainWindow (GetFocus ())
Let hMDI = FindFirstWindowWithClass (GetFirstChild (appWin), wcRecordParent)
Let hInfo = FindFirstWindowWithClass (GetFirstChild (hMDI),  wcInfoO)
Let hDialog = FindFirstWindowWithClass (GetFirstChild (hInfo),  wcDialog)
Let hTab = FindFirstWindowWithClass (GetFirstChild (hDialog), wcMsTab)
Let MSTabHandle = hTab
SaveCursor ()
JAWSCursor ()
MoveToWindow (hTab)
Let PageListTemp = GetLine ()
; The string returned by GetLine lists the page names delimited by two spaces between each page name.  The SelectAnItemDlg function only
; accepts a verticle var delimited list.  Before returning the page list, each ocurrance of "  " needs to be replaced with a | in order
; to be compatable with SelectAnItemDlg.  In order to ddo this, walk through the string finding each occurance of " " and each time
; it is found divide the string into two segments, one preceeding and one following the pair of spaces, and then recombine the
; substrings into one string with a | placed in between.  Then return the | delimited list of pages.
Let pos = StringContains (PageListTemp, "  ")
While (pos)
	Let nLength = StringLength (PageListTemp)
	Let strTemp = SubString (PageListTemp, 1, pos - 1)
	Let strTempA = SubString (PageListTemp, pos + 2, nLength)
	Let PageListTemp = strTemp + "\007" + strTempA
	Let pos = StringContains (PageListTemp, "  ")
EndWhile
Let PageList = PageListTemp
RestoreCursor ()
Return PageList
EndFunction

Int Function IsOrgChartVisible ()
Var Handle fWin, Handle hOrgChart, Handle hOrgChartParent
;  Walk down the window heirarchy to determine if the organizational chart is visible.
;  App MAin Window -> First descendent window with class GMOrgWnd -> Find descendent window with control ID of 710
Let fWin = GetFocus ()
Let hOrgChartParent = FindFirstWindowWithClass (fWin, wcRecordSecondChild)
Let hOrgChart = FindDescendantWindow (hOrgChartParent, ID_OrgChart)
If (IsRecordViewVisible () && IsOrgChart () == 0) then
	If (IsWindowVisible (hOrgChart)) then
		Return 1
	EndIf
ElIf (IsOrgChart () == 1) then
	Return 1
EndIf
Return 0
EndFunction


Int Function IsCalendar ()
Var Handle cWin, Handle fWin, Handle pWin, Handle gpWin, String cwClass, String fwClass, String pwClass, String gpwClass
; Compares the focus window class, the current window class, the class of the parent of the current window, and the class of the
; grandparent window of the current window to classes that are known to be found only in the GoldMine Calendar
Let cWin = GetCurrentWindow ()
Let fWin = GetFocus ()
Let pWin = GetParent (cWin)
Let gpWin = GetParent (pWin)
Let cwClass = GetWindowClass (cWin)
Let fwClass = GetWindowClass (fWin)
Let pwClass = GetWindowClass (pWin)
Let gpwClass = GetWindowClass (gpWin)
If (fwClass ==  wcCal) then Return 1
ElIf (fwClass == wcCalM) then Return 1
ElIf (pwClass == wcCalO) then Return 1
ElIf (gpwClass == wcCal) then Return 1
ElIf (gpwClass == wcCalO) then Return 1 EndIf
EndFunction

String Function GetActiveToolbar (int ByRef nToolbar)
Var String hToolbarList, Int nCount, Int tmpHandle, Int bSuccess
; Get the number of windows found that have a window class of ATC_ToolbarWindow and a verticle bar delimited list of the window handles
;Let hToolbarList = FindAllWindowsWithClass (GetFirstChild (GetAppMainWindow (GetCurrentWindow ())), wcTool_bar, nCount)
Let hToolbarList = GetAllToolBarWindows (nCount)
Let nToolbar = 0
Let bSuccess = 0
If (nCount == 1) then
	SaveCursor ()
	Let tmpHandle = StringToInt (StringSegment (hToolbarList, "\007", 1))
	Let bSuccess = FindGraphic (tmpHandle, strGettingStartedButton, S_TOP, S_RESTRICTED)
	If (bSuccess) then
		Let nToolbar = Toolbar_GettingStarted
		RestoreCursor ()
		Return hToolbarList
	ElIf (!bSuccess) then
		Let bSuccess = FindString (tmpHandle, strGettingStarted, S_TOP, S_RESTRICTED)
		If (bSuccess) then
			Let nToolbar = Toolbar_GettingStarted
			RestoreCursor ()
			Return hToolbarList
		EndIf
	EndIf
	Let bSuccess = FindGraphic (tmpHandle, strBasicButton, S_TOP, S_RESTRICTED)
	If (bSuccess) then
		Let nToolbar = Toolbar_Basic
		RestoreCursor ()
		Return hToolbarList
	ElIf (!bSuccess) then
		Let bSuccess = FindString (tmpHandle, strBasic, S_TOP, S_RESTRICTED)
		If (bSuccess) then
			Let nToolbar = Toolbar_Basic
			RestoreCursor ()
			Return hToolbarList
		EndIf
	EndIf
EndIf
; Five toolbar windows found, Standard Toolbar
If (nCount == 5) then
	Let nToolbar = Toolbar_Standard
EndIf
; Seven toolbar windows found, Advanced Toolbar
If (nCount == 7) then
	Let nToolbar = Toolbar_Advanced
EndIf
; Return hToolbar List so that it may be used by select a tool
Return hToolbarList
EndFunction

Int Function GettingStartedToolbar (handle hWin)
Var Int nIndex, Int bSuccess
; Display a list box of available toolbar buttons and return the index of the selected item
Let nIndex = DlgSelectItemInList (gsButtonListA + gsButtonListB + gsButtonListC, "Select A Tool - Getting Started Toolbar", FALSE)
If (nIndex == 0) then Return 2 EndIf
If (nIndex != 0) then
	SaveCursor ()
	If (FindGraphic (hWin, StringSegment (gsButtonListA + gsButtonListB + gsButtonListC, "|", nIndex), S_TOP, S_UNRESTRICTED)) then
		Let bSuccess = 1
		LeftMouseButton ()
	ElIf (FindString (hWin, StringSegment (gsButtonText, "|", nIndex), S_TOP, S_UNRESTRICTED)) then
		Let bSuccess = 1
		LeftMouseButton ()
	Else
		Let bSuccess = 0
	EndIf
EndIf
RestoreCursor ()
Return bSuccess
EndFunction

Int Function BasicToolbar (handle hWin)
Var Int nIndex, Int bSuccess
; Display a list box of available toolbar buttons and return the index of the selected item
Let nIndex = DlgSelectItemInList (bButtonListA + bButtonListB + bButtonListC + bButtonListD + bButtonListE + bButtonListF, "Select A Tool - Basic Toolbar", FALSE)
If (nIndex == 0) then Return 2 EndIf
; If nToolbarType = ButtonTextVisible, search for the string in the toolbar window that corresponds to the selected item in the list.
; Then route the JAWS cursor to the strings location and press the left mouse button.  If nToolbarType = ButtonTextNotVisible, use the
; modified FindGraphic function to search for the graphic in the toolbar window that corresponds to the selected item in the list.
; Then route the JAWS cursor to the strings location and press the left mouse button.
If (nIndex != 0) then
	SaveCursor ()
	If (FindGraphic (hWin, StringSegment (bButtonListA + bButtonListB + bButtonListC + bButtonListD + bButtonListE + bButtonListF, "|", nIndex), S_TOP, S_UNRESTRICTED)) then
		Let bSuccess = 1
		LeftMouseButton ()
	ElIf (FindString (hWin, StringSegment (bButtonTextA + bButtonTextB, "|", nIndex), S_TOP, S_UNRESTRICTED)) then
		Let bSuccess = 1
		LeftMouseButton ()
	Else
		Let bSuccess = 0
	EndIf
EndIf
RestoreCursor ()
Return bSuccess
EndFunction

Int Function StandardToolbar (string strHandleList)
Var Int nIndex, Int bSuccess, Int hHandleA, Int hHandleB, Int hHandleC, Int hHandleD, Int hHandleE, Int nItem
Let bSuccess = 0
; Get each of the window handles from the toolbar window handle list.
Let hHandleA = StringToInt(StringSegment (strHandleList, "\007", 1))
Let hHandleB = StringToInt(StringSegment (strHandleList, "\007", 2))
Let hHandleC = StringToInt(StringSegment (strHandleList, "\007", 3))
Let hHandleD = StringToInt(StringSegment (strHandleList, "\007", 4))
Let hHandleE = StringToInt(StringSegment (strHandleList, "\007", 5))
; Display a list box of available toolbar buttons and return the index of the selected item
Let nIndex = DlgSelectItemInList (ButtonListStandardA + ButtonListStandardB + ButtonListScheduleA + ButtonListScheduleB + ButtonListEmailA + ButtonListEmailB + ButtonListRecordA + ButtonListRecordB + ButtonListToolsA + ButtonListToolsB, "Select A Tool - Standard Toolbar", FALSE)
If (nIndex == 0) then Return 2 EndIf
; Determine which toolbar window the selected item can be found in, isolate the item number of the selected toolbar button from the list of
; toolbar icons from the appropriate window, and search that window for the item chosen.
If (nIndex != 0) then
	SaveCursor ()
	If (nIndex <= StandardNumber) then
		If (FindGraphic (hHandleA, StringSegment (ButtonListStandardA + ButtonListStandardB, "|", nIndex), S_TOP, S_UNRESTRICTED)) then
			Let bSuccess = 1
			LeftMouseButton ()
		ElIf (FindString (hHandleA, StringSegment (ButtonTextStandard, "|", nIndex), S_TOP, S_UNRESTRICTED)) then
			Let bSuccess = 1
			LeftMouseButton ()
		Else
			Let bSuccess = 0
		EndIf
	ElIf (nIndex > StandardNumber && nIndex <= ScheduleNumber) then
		Let nItem = nIndex - StandardNumber
		If (FindGraphic (hHandleB, StringSegment (ButtonListScheduleA + ButtonListScheduleB, "|", nItem), S_TOP, S_UNRESTRICTED)) then
			Let bSuccess = 1
			LeftMouseButton ()
		ElIf (FindString (hHandleB, StringSegment (ButtonTextSchedule, "|", nItem), S_TOP, S_UNRESTRICTED)) then
			Let bSuccess = 1
			LeftMouseButton ()
		Else
			Let bSuccess = 0
		EndIf
	ElIf (nIndex > ScheduleNumber && nIndex <= EmailNumber) then
		; Limit find string and find graphic functions to third handle
		Let nItem = nIndex - ScheduleNumber
		If (FindGraphic (hHandleC, StringSegment (ButtonListEmailA + ButtonListEmailB, "|", nItem), S_TOP, S_UNRESTRICTED)) then
			Let bSuccess = 1
			LeftMouseButton ()
		ElIf (FindString (hHandleC, StringSegment (ButtonTextEmail, "|", nItem), S_TOP, S_UNRESTRICTED)) then
			Let bSuccess = 1
			LeftMouseButton ()
		Else
			Let bSuccess = 0
		EndIf
	ElIf (nIndex > EmailNumber && nIndex <= RecordNumber) then
		; Limit find string and find graphic functions to the fourth handle
		Let nItem = nIndex - EmailNumber
		If (FindGraphic (hHandleD, StringSegment (ButtonListRecordA + ButtonListRecordB, "|", nItem), S_TOP, S_UNRESTRICTED)) then
			Let bSuccess = 1
			LeftMouseButton ()
		ElIf (FindString (hHandleD, StringSegment (ButtonTextRecord, "|", nItem), S_TOP, S_UNRESTRICTED)) then
			Let bSuccess = 1
			LeftMouseButton ()
		Else
			Let bSuccess = 0
		EndIf
	ElIf (nIndex > RecordNumber && nIndex <= ToolsNumber) then
		; Limit find string and find graphic functions to the fifth handle
		Let nItem = nIndex - RecordNumber
		If (FindGraphic (hHandleE, StringSegment (ButtonListToolsA + ButtonListToolsB, "|", nItem), S_TOP, S_UNRESTRICTED)) then
			Let bSuccess = 1
			LeftMouseButton ()
		ElIf (FindString (hHandleE, StringSegment (ButtonTextTools, "|", nItem), S_TOP, S_UNRESTRICTED)) then
			Let bSuccess = 1
			LeftMouseButton ()
		Else
			Let bSuccess = 0
		EndIf
	EndIf
EndIf
RestoreCursor ()
Return bSuccess
EndFunction

Int Function AdvancedToolbar (String strHandleList)
Var Int nIndex, Int bSuccess, Int hHandleA, Int hHandleB, Int hHandleC, Int hHandleD, Int hHandleE, Int hHandleF, Int hHandleG, Int nItem
Let bSuccess = 0
; Get each of the window handles from the toolbar window handle list.
Let hHandleA = StringToInt(StringSegment (strHandleList, "\007", 1))
Let hHandleB = StringToInt(StringSegment (strHandleList, "\007", 2))
Let hHandleC = StringToInt(StringSegment (strHandleList, "\007", 3))
Let hHandleD = StringToInt(StringSegment (strHandleList, "\007", 4))
Let hHandleE = StringToInt(StringSegment (strHandleList, "\007", 5))
Let hHandleF = StringToInt(StringSegment (strHandleList, "\007", 6))
Let hHandleG = StringToInt(StringSegment (strHandleList, "\007", 7))
; Display a list box of available toolbar buttons and return the index of the selected item
Let nIndex = DlgSelectItemInList (ButtonListStandardA + ButtonListStandardB + ButtonListScheduleA + ButtonListScheduleB + ButtonListEmailA + ButtonListEmailB + ButtonListRecordA + ButtonListRecordB + ButtonListToolsA + ButtonListToolsB + ButtonListMisc + ButtonListSetupA + ButtonListSetupB, "Select A Tool - Advanced Toolbar", FALSE)
If (nIndex == 0) then Return 2 EndIf
; Determine which toolbar window the selected item can be found in, isolate the item number of the selected toolbar button from the list of toolbar icons from the appropriate window, and search
;	that window for the item chosen.
If (nIndex != 0) then
	SaveCursor ()
	If (nIndex <= StandardNumber) then
		If (FindGraphic (hHandleA, StringSegment (ButtonListStandardA + ButtonListStandardB, "|", nIndex), S_TOP, S_UNRESTRICTED)) then
			Let bSuccess = 1
			LeftMouseButton ()
		ElIf (FindString (hHandleA, StringSegment (ButtonTextStandard, "|", nIndex), S_TOP, S_UNRESTRICTED)) then
			Let bSuccess = 1
			LeftMouseButton ()
		Else
			Let bSuccess = 0
		EndIf
	ElIf (nIndex > StandardNumber && nIndex <= ScheduleNumber) then
		Let nItem = nIndex - StandardNumber
		If (FindGraphic (hHandleB, StringSegment (ButtonListScheduleA + ButtonListScheduleB, "|", nItem), S_TOP, S_UNRESTRICTED)) then
			Let bSuccess = 1
			LeftMouseButton ()
		ElIf (FindString (hHandleB, StringSegment (ButtonTextSchedule, "|", nItem), S_TOP, S_UNRESTRICTED)) then
			Let bSuccess = 1
			LeftMouseButton ()
		Else
			Let bSuccess = 0
		EndIf
	ElIf (nIndex > ScheduleNumber && nIndex <= EmailNumber) then
		; Limit find string and find graphic functions to third handle
		Let nItem = nIndex - ScheduleNumber
		If (FindGraphic (hHandleC, StringSegment (ButtonListEmailA + ButtonListEmailB, "|", nItem), S_TOP, S_UNRESTRICTED)) then
			Let bSuccess = 1
			LeftMouseButton ()
		ElIf (FindString (hHandleC, StringSegment (ButtonTextEmail, "|", nItem), S_TOP, S_UNRESTRICTED)) then
			Let bSuccess = 1
			LeftMouseButton ()
		Else
			Let bSuccess = 0
		EndIf
	ElIf (nIndex > EmailNumber && nIndex <= RecordNumber) then
		; Limit find string and find graphic functions to the fifth handle
		Let nItem = nIndex - EmailNumber
		If (FindGraphic (hHandleE, StringSegment (ButtonListRecordA + ButtonListRecordB, "|", nItem), S_TOP, S_UNRESTRICTED)) then
			Let bSuccess = 1
			LeftMouseButton ()
		ElIf (FindString (hHandleE, StringSegment (ButtonTextRecord, "|", nItem), S_TOP, S_UNRESTRICTED)) then
			Let bSuccess = 1
			LeftMouseButton ()
		Else
			Let bSuccess = 0
		EndIf
	ElIf (nIndex > RecordNumber && nIndex <= ToolsNumber) then
		; Limit find string and find graphic functions to the sixth handle
		Let nItem = nIndex - RecordNumber
		If (FindGraphic (hHandleF, StringSegment (ButtonListToolsA + ButtonListToolsB, "|", nItem), S_TOP, S_UNRESTRICTED)) then
			Let bSuccess = 1
			LeftMouseButton ()
		ElIf (FindString (hHandleF, StringSegment (ButtonTextTools, "|", nItem), S_TOP, S_UNRESTRICTED)) then
			Let bSuccess = 1
			LeftMouseButton ()
		Else
			Let bSuccess = 0
		EndIf
	ElIf (nIndex > ToolsNumber && nIndex <= MiscNumber) then
		; Limit find string and find graphic functions to the fourth handle
		Let nItem = nIndex - ToolsNumber
		If (FindGraphic (hHandleD, StringSegment (ButtonListMisc, "|", nItem), S_TOP, S_UNRESTRICTED)) then
			Let bSuccess = 1
			LeftMouseButton ()
		ElIf (FindString (hHandleD, StringSegment (ButtonTextMisc, "|", nItem), S_TOP, S_UNRESTRICTED)) then
			Let bSuccess = 1
			LeftMouseButton ()
		Else
			Let bSuccess = 0
		EndIf
	ElIf (nIndex > MiscNumber && nIndex <= SetupNumber) then
		; Limit find string and find graphic functions to the eighth handle
		Let nItem = nIndex - MiscNumber
		If (FindGraphic (hHandleG, StringSegment (ButtonListSetupA + ButtonListSetupB, "|", nItem), S_TOP, S_UNRESTRICTED)) then
			Let bSuccess = 1
			LeftMouseButton ()
		ElIf (FindString (hHandleG, StringSegment (ButtonTextSetup, "|", nItem), S_TOP, S_UNRESTRICTED)) then
			Let bSuccess = 1
			LeftMouseButton ()
		Else
			Let bSuccess = 0
		EndIf
	EndIf
EndIf
RestoreCursor ()
Return bSuccess
EndFunction

String Function GetCalendarPageName ()
Var Handle AppWin, Handle hMDI, Handle hGMCal, Handle hSysTab, Handle hSysTabChild, Handle hWin, Handle hWinChild, Handle hNext, String hNextClass
; Determine the active page by searching through the window heirarchy for windows that are only found if a specific page is active.
Let AppWin = GetAppMainWindow (GetFocus ())
Let hMDI = FindFirstWindowWithClass (GetFirstChild (AppWin), wcRecordParent)
Let hGMCal = FindFirstWindowWithClass (GetFirstChild (hMDI), wcCal)
Let hSysTab = FindFirstWindowWithClass (GetFirstChild (hGMCal), wcMsTab)
If (FindFirstWindowWithClass (GetFirstChild (hSysTab), wcCalO) != 0) then Return CalO
ElIf (FindFirstWindowWithClass (GetFirstChild (hSysTab), wcCalPB) != 0) then Return CalP
Else Let hSysTabChild = FindFirstWindowWithClass (GetFirstChild (hSysTab), wcCalM) EndIf
If (hSysTabChild != 0) then
	If (GetFirstChild (hSysTabChild)) then Return CalM
	Else Return CalY EndIf
Else Let hSysTabChild = FindFirstWindowWithClass (GetFirstChild (hSysTab), wcCalDay) EndIf
If (hSysTabChild) then
	Let hWinChild = GetFirstChild (hSysTabChild)
	Let hNext = GetNextWindow (hWinChild)
	Let hNextClass = GetWindowClass (hNext)
	If (hNextClass == wcCalM) then Return CalD
	ElIf (hNextClass == wcCalT) then Return CalW
	ElIf (hNextClass == wcUpDown) then Return CalPL EndIf
EndIf
EndFunction

Int Function IsCalendarDateLookup ()
Var Handle rWin, Handle fcWin
;  Determine if the window class of the first child window of the focus window is gmF2Cal
Let rWin = GetRealWindow (GetFocus ())
Let fcWin = GetFirstChild (rWin)
If (GetWindowClass (fcWin) == wcCalLookup) then Return 1
Else Return 0 EndIf
EndFunction

String Function GetActivePageName ()
Var String cwClass, String strPageName, String strTitle, Handle rWin, String strTest
Let cwClass = GetWindowClass (GetCurrentWindow ())
SaveCursor ()
If (IsRecordViewVisible () == 0 && IsActivityListDialog () == 0) then Return EndIf
If (IsRecordViewVisible () == 1) then
	Let strPageName = ""
; If the notes window can be found by searching through the window hierarchy then the active page is notes
	If (FindNotesWindow ()) then Let strPageName = NotesPage
; In the GoldMine Record view, most pages have a window class of gmWndBrowse.  Search through the window Hierarchy for the browse window and obtain the window name of the browse
; Window.  If no window name is returned, get the line of text where the column titles are displayed.  Search the text string obtained for specific strings that are particular to a specific page.
	ElIf (FindBrowseWindow ()) then
		Let strTest = GetWindowName (FindBrowseWindow ())
		If (strTest == "" && FindBrowseWindow () != 0) then
			SaveCursor ()
			JAWSCursor ()
			MoveToWindow (FindBrowseWindow ())
			Let strTest = GetLine ()
			RestoreCursor ()
		EndIf
		If (StringContains (strTest, msg052)) then Let strPageName = ContactsPage
		ElIf (StringContains (strTest, msg053)) then Let strPageName = ProfilesPage
		ElIf (StringContains (strTest, msg054)) then Let strPageName = ReferralsPage
		ElIf (StringContains (strTest, msg055) && StringContains (strTest, msg056)) then Let strPageName = PendingPage
		ElIf (StringContains (strTest, msg055) && StringContains (strTest, msg057)) then Let strPageName = HistoryPage
		ElIf (StringContains (strTest, msg058)) then Let strPageName = LinksPage
		ElIf (StringContains (strTest, msg059)) then Let strPageName = MembersPage
		ElIf (StringContains (strTest, msg060) && StringContains (strTest, msg076) == 0) then Let strPageName = TracksPage
		ElIf (StringContains (strTest, msg061)) then Let strPageName = OpportunitiesPage
		ElIf (StringContains (strTest, msg062)) then Let strPageName = ProjectsPage
		ElIf (StringContains (strTest, msg063)) then Let strPageName = LinksPage
		ElIf (StringContains (strTest, msg075)) then Let strPageName = PartnerPage
		ElIf (StringContains (strTest, msg076)) then Let strPageName = PCPage
	 EndIf
	Else
; The summary page and fields page are parts of the GMRecord window.  To distinguish between the pages, search the record window for an identifying string of text.
		If (FindString (FindRecordWindow (), msg077, S_BOTTOM, S_RESTRICTED)) then 
			Let strPageName = SummaryPage
		ElIf (FindString (FindRecordWindow (), msg078, S_BOTTOM, S_UNRESTRICTED) 
			|| FindString (FindRecordWindow (), msg079, S_BOTTOM, S_UNRESTRICTED) 
			|| FindString (FindRecordWindow (), msg079a, S_BOTTOM, S_UNRESTRICTED)
			|| FindString (FindRecordWindow (), FieldsPageCustomString1, S_BOTTOM, S_UNRESTRICTED)
			|| FindString (FindRecordWindow (), FieldsPageCustomString2, S_BOTTOM, S_UNRESTRICTED)) then 
			Let strPageName = FieldsPage 
		EndIf
	EndIf
; If the page name cannot be determined, return Unknown
	If (strPageName == "") then Let strPageName = "Unknown" EndIf
EndIf
RestoreCursor ()
; In the Activity list dialog box, search the real window title for a string of text that uniquely identifies a particular page.
If (IsActivityListDialog () == 1) then
	Let rWin = GetRealWindow (GetFocus ())
	Let strTitle = GetWindowName (rWin)
	If (StringContains (strTitle, msg064)) then Let strPageName = OpenPage
	ElIf (StringContains (strTitle, msg065)) then Let strPageName = EmailPage
	ElIf (StringContains (strTitle, msg066)) then Let strPageName = OutboxPage
	ElIf (StringContains (strTitle, msg067)) then Let strPageName = CallsPage
	ElIf (StringContains (strTitle, msg068)) then Let strPageName = AppointmentsPage
	ElIf (StringContains (strTitle, msg069)) then Let strPageName = ForecastPage
	ElIf (StringContains (strTitle, msg070)) then Let strPageName = ActionsPage
	ElIf (StringContains (strTitle, msg071)) then Let strPageName = ToDoPage
	ElIf (StringContains (strTitle, msg072)) then Let strPageName = ClosedPage
	ElIf (StringContains (strTitle, msg073)) then Let strPageName = FiledPage
	ElIf (StringContains (strTitle, msg074)) then Let strPageName = RealTimePage EndIf
EndIf
Return strPageName
EndFunction

Void Function AnnounceActivePageName ()
Var String cwClass
Delay (2)
Let cwClass = GetWindowClass (GetCurrentWindow ())
; Obtain the name of the active page from GetActivePageName and speak it.
If (cwClass == wcRecord || cwClass == wcBrowse || cwClass == wcNotes) then
	Let strPageName = GetActivePageName ()
	Say (strPageName, ot_message)
	If (GetVerbosity () == BEGINNER) then Say (msg037, ot_message) Else Say (msg038, ot_message) EndIf
EndIf
EndFunction

Void Function AnnounceGoldMineAlarm ()
;  Say GoldMine Alarm thre times and then announce how to move focus to the GoldMine Alarm window.  Then restore typing echo to its previous setting.
While AnnounceGMAlarmCalled <= 4
	Let AnnounceGMAlarmCalled = AnnounceGMAlarmCalled + 1
	If (AnnounceGMAlarmCalled < 4) then
		Say (msgGMAlarmAlert, ot_message)
	ElIf (AnnounceGMAlarmCalled == 4) then
		Delay (2)
		Say (msgMoveToGMAlarm + GetScriptKeyName ("MoveFocusToGMAlarm"), ot_message)
	EndIf
	ScheduleFunction ("AnnounceGoldMineAlarm", 3)
EndWhile
SetDefaultJCFOption (OPT_TYPING_INTERRUPT, PriorJCFOpt)
EndFunction

; *** Event functions begin here
void Function AutoStartEvent ()
if (GoldMineFirst ==0) then
	 let GoldMineFirst = 1
	 If (GetVerbosity () == BEGINNER) then
		 SayExtendedHelpHotKey ()
		 Say (msg001, OT_HELP) ; "Use insert + h for helpful keystrokes",
		 Say (msg002, OT_HELP) ; "Press insert + f1 for ScreenSensitive Help"
		 Say (msg003, OT_HELP) ; "For best results, maximize the main window and all GoldMine child windows"
	Else Say (msg000, ot_message)
	EndIf
EndIf
Let PriorJCFOpt = GetDefaultJCFOption (OPT_TYPING_INTERRUPT)
EndFunction

Void Function FocusPointMovedEvent (int nX, int nY, int nOldX, int nOldY, int nUnit, int nDir, int nTimeElapsed)
Var handle hwnd, string TheClass, Int nL, Int nR, Int nT, Int nB, String prevFieldLabel
If (nSuppressEcho == TRUE) then
	Return
EndIf
let hwnd = GetFocus ()
let TheClass = GetWindowClass (hwnd)
; When in edit contact record mode, control the speaking of the field labels as the user moves from field to field
If (TheClass == WCField) then
	Let prevFieldLabel = strFieldLabel
	Let strFieldLabel = GetFieldLabel ()
	If (strFieldLabel == "") then
		Pause ()
	EndIf
	If (prevFieldLabel != strFieldLabel) then
		Say (strFieldLabel, ot_buffer)
		If (GetItemRect (GetCursorCol (), GetCursorRow (), nL, nR, nT, nB, IT_CARET) == TRUE) then Say (msg016, ot_message) EndIf
		Say (GetWindowText (hwnd, FALSE), ot_buffer)
	Else

	EndIf
EndIf
EndFunction

Function FocusChangedEvent (handle FocusWindow, handle PrevWindow)
Var Handle rWin, String rWinTitle, Handle hTarget, Int nX, Int nY, Int nW, Int nH
Let rWin = GetRealWindow (GetCurrentWindow ())
Let rWinTitle = GetWindowName (rWin)
If (rWinTitle == wnMergeForms
	&& rWin != GlobalPrevReal) then
	Let hTarget = GetFirstChild (rWin)
	If (GetWindowClass (hTarget) == wcGmDlgBrowse) then
		Let nW = GetWindowRight (hTarget) - GetWindowLeft (hTarget)
		Let nH = GetWindowBottom (hTarget) - GetWindowTop (hTarget)
		Let nX = GetWindowRight (hTarget) - (nW / 10)
		Let nY = GetWindowTop (hTarget) + (nH / 10)
		SaveCursor ()
		JAWSCursor ()
		MoveTo (nX, nY)
		LeftMouseButton ()
		RestoreCursor ()
	EndIf
EndIf
FocusChangedEvent (FocusWindow, PrevWindow)
EndFunction

Void Function SayFocusedWindow ()
Var Handle rWin, Int nTest, Int nL, Int nR, Int nT, Int nB, Int nL1, Int nR1, Int nT1, Int nB1, Handle tmpHandle,
	Handle tmpHandle1, Handle tmpHandle2, Handle tmpHandle3, String pwClass, Handle AppWin, String curWinName
Let rWin = GetRealWindow (GetCurrentWindow ())
Let AppWin = GetAppMainWindow (GetFocus ())
Let pwClass = cwClass
Let cwClass = GetWindowClass (GetCurrentWindow ())
Let curWinName = GetWindowName (GetCurrentWindow ())
; Properly speak the names of certain controls in the GoldMine environment
If (GetWindowName (rWin) == wnSelUser && GetCurrentControlID () == ID_SelUserLB) then
	Say (hmsg076, ot_message)
	Return
EndIf
If (IsCalendar ()) then
	If (GetCurrentControlID () == ID_PDB) then Say (msg044, ot_message) Return EndIf
	If (GetCurrentControlID () == ID_TB) then Say (msg045, ot_message) Return EndIf
	If (GetCurrentControlID () == ID_NDB) then Say (msg045a, ot_message) Return EndIf
	If (GetCurrentControlID () == ID_UserCB) then Say (msg046, ot_message) Return EndIf
	If (GetCurrentControlID () == ID_SelUser) then Say (msg047, ot_message) Return EndIf
	If (GetCurrentControlID () == ID_CalO) then Say (msg048, ot_message) Return EndIf
EndIf
If (GetWindowClass (rWin) == wcDialog && GetWindowClass (GetFirstChild (rWin)) == wcCalLookup) then
	If (GetCurrentControlID () == ID_CalTodayButton) then Say (msg049, ot_message) EndIf
	If (GetCurrentControlID () == ID_CalDateLookup) then Say (msg051, ot_message) EndIf
EndIf
If (GlobalPrevReal != rWin) then
; Say the record identifier when leaving dialog boxes and returninig to the main record view
	If (IsRecordViewVisible () && cwClass != wcField && pwClass != wcField && StringContains (GlobalPrevRealName, "Select A ") == 0) then 
		If (AppWin != GlobalPrevApp) then
		Else
			SayRecordIdentifier () 
		EndIf
	EndIf
; In the GoldMine Alarm window build two dynamic frames to surround the text located between the various buttons and say the text.  Then say the current control.
	If (IsGoldMineAlarm ()) then
		Let tmpHandle = FindDescendantWindow (rWin, ID_Static)
		Let tmpHandle1 = FindDescendantWindow (rWin, ID_Off)
		Let tmpHandle2 = FindDescendantWindow (rWin, ID_DeleteB)
		Let tmpHandle3 = FindDescendantWindow (rWin, ID_NotesB)
		Let nT = GetWindowBottom (tmpHandle) + 15
		Let nB = GetWindowBottom (tmpHandle2)
		Let nL = GetWindowLeft (rWin)
		Let nR = GetWindowLeft (tmpHandle2)
		Let nT1 = nB + 2
		Let nL1 = nL
		Let nR1 = GetWindowRight (rWin)
		Let nB1 = GetWindowTop (tmpHandle3)
		SayTextBetweenTwoPoints (nL, nT, nR, nB)
		SayTextBetweenTwoPoints (nL1, nT1, nR1, nB1)
		SayWindowTypeAndText (GetCurrentWindow ())
		Return
; In the Schedule Conflict Dialog build a dynamic frames to surround the text located between the buttons and the title bar and say the text.  Then say the current control.
	ElIf (IsScheduleConflictDialog ()) then
		Let tmpHandle = FindDescendantWindow (rWin, ID_Static)
		Let nT = GetWindowBottom (tmpHandle) + 15
		Let nL = GetWindowLeft (rWin)
		Let nR = GetWindowRight (rWin)
		Let nB = GetWindowTop (GetCurrentWindow ())
		SayTextBetweenTwoPoints (nL, nT, nR, nB)
		SayWindowTypeAndText (GetCurrentWindow ())
		Return
	EndIf
EndIf
If (GetWindowClass (GetFocus ()) == wcRecord || GetWindowClass (GetFocus ()) == wcBrowse) then
	Return
Else
	SayWindowTypeAndText (GlobalFocusWindow)
	Delay (1)
; Say the contents of the note field in the Complete a Call Back window
;  If (GetWindowName (rWin) == msg080) then
	 If (GetWindowName (GetCurrentWindow ()) == msg081) then
		 SayWindow (GetCurrentWindow (), READ_HIGHLIGHTED)
	 EndIf
;  EndIf
EndIf
EndFunction

Void Function WindowCreatedEvent (handle hWindow, int nLeft, int nTop, int nRight, int nBottom)
Var Handle rWin
Let rWin = GetRealWindow (hWindow)
; If the newly created window is the GoldMine Alarm window, disable typing interrupt and call the function AnnounceGoldMineAlarm.
If (StringContains (GetWindowName (rWin), msg050)) then
	Let GMAlarm = rWin
	Let AnnounceGMAlarmCalled = 0
	StopSpeech ()
	SetDefaultJcfOption (OPT_TYPING_INTERRUPT, OFF)
	ScheduleFunction ("AnnounceGoldMineAlarm", 3)	
EndIf
EndFunction

Void Function SayHighLightedText (handle hwnd, string buffer)
; HighlightedText Function for speaking all newly written highlighted
; text.
;If (IsCalendar () && GetWindowClass (hwnd) == wcOrgChart) then Return EndIf
; Prevent overspeaking in the GoldMine Calendar by preventing highlighted text in the GMCalMon window
If (GetWindowClass (hwnd) == wcCalM) then Return EndIf
if (GetWindowSubTypeCode (hwnd) == WT_TREEVIEW) Then
	SayTreeViewLevel ()
	Return
EndIf
if (GetScreenEcho() > 0) then Say (buffer, ot_buffer) EndIf
EndFunction

; *** Scripts begin here

Script MoveFocusToGMAlarm ()
SaveCursor ()
JAWSCursor ()
MoveTo (GetWindowLeft (GMAlarm) + 30, GetWindowTop (GMAlarm) + 10)
LeftMouseButton ()
RestoreCursor ()
EndScript


Script ScriptFileName ()
ScriptAndAppNames (msg019)
EndScript

Script NextRecord ()
; for Edit classes
Var String cwClass
; If not in record view or the notes window is active, allow PageUp to perform its standard function
Let cwClass = GetWindowClass (GetCurrentWindow ())
if (GetWindowClass (GetFocus ()) == WCField) || (GetWindowClass (GetFocus ()) == WCNotes) || (GetWindowClass (GetFocus ()) == wcEdit) then
	PerformScript JawsPageDown()
	Return
EndIf
; If in record view and the notes window is not active, move to the next record
If (IsPcCursor ()) then ; don't disable JawsPageDown ()
	{PageDown}
	If (IsRecordViewVisible () == 1) then
		If GetVerbosity () == 0 then
			Say (msg020 + msg021, OT_MESSAGE) ; "Next Record"
		EndIf
		If GetVerbosity () == 1 then
			Say (msg020, OT_MESSAGE) ; "Next"
		EndIf
		Pause ()
		SayRecordIdentifier ()
	EndIf
Else ; if other cursor is active
PerformScript JawsPageDown()
EndIf
EndScript

Script PreviousRecord ()
Var String cwClass
; If not in record view or the notes window is active, allow PageDown to perform its standard function
Let cwClass = GetWindowClass (GetCurrentWindow ())
; for Edit classes
if ((GetWindowClass (GetFocus ()) == WCField) || (GetWindowClass (GetFocus ()) == WCNotes) || (GetWindowClass (GetFocus ()) == wcEdit)) then
	PerformScript JawsPageUp()
	Return
EndIf
; If in record view and the notes window is not active, move to the prior record
If (IsPcCursor ()) then ; don't disable JawsPageUp ()
	{PageUp}
	If (IsRecordViewVisible () == 1) then
		If GetVerbosity () == 0 then
			Say (msg022 + msg021, OT_MESSAGE) ; "Previous Record"
		EndIf
		If GetVerbosity () == 1 then
		 Say (msg022, OT_MESSAGE) ; "Previous"
		EndIf
		Pause ()
		SayRecordIdentifier ()
	EndIf
Else ; if other cursor is active
PerformScript JawsPageUp()
EndIf
EndScript

Script FirstRecord ()
Var String cwClass
{ctrl+PageUp}
Let cwClass = GetWindowClass (GetCurrentWindow ())
If (IsRecordViewVisible ()) then
	If GetVerbosity () == 0 then
		Say (msg023 + msg022, OT_MESSAGE) ; "First Record"
	EndIf
	If GetVerbosity () == 1 then
		Say (msg023, OT_MESSAGE) ; "First"
	EndIf
	Pause ()
	SayRecordIdentifier ()
EndIf
EndScript

Script LastRecord ()
Var String cwClass
{ctrl+PageDown}
Let cwClass = GetWindowClass (GetCurrentWindow ())
If (IsRecordViewVisible ()) then
	If GetVerbosity () == 0 then
		Say (msg024 + msg022, OT_MESSAGE) ; "Last Record"
	EndIf
	If GetVerbosity () == 1 then
		Say (msg024, OT_MESSAGE) ; "Last"
	EndIf
	Pause ()
	SayRecordIdentifier ()
EndIf
EndScript

Script LastViewedRecord ()
Var String cwClass
{shift+PageUp}
Let cwClass = GetWindowClass (GetCurrentWindow ())
If (IsRecordViewVisible ()) then
	Say (msg024 + msg025, OT_MESSAGE) ; "Last Viewed Record"
	SayRecordIdentifier ()
EndIf
EndScript

Script EditRecord ()
Var String cwClass
{ctrl+e}
Let cwClass = GetWindowClass (GetCurrentWindow ())
If (cwClass == WCField) then
	If GetVerbosity () == 0 then
		Say (msg026, OT_MESSAGE) ; "Edit Record"
	EndIf
EndIf
EndScript

Script ControlPlusS ()
Var String cwClass
{Control + S}
Let cwClass = GetWindowClass (GetCurrentWindow ())
If (IsRecordViewVisible ()) then
	AnnounceActivePageName ()
EndIf
EndScript

Script ControlPlusF ()
Var String cwClass
{Control + F}
Let cwClass = GetWindowClass (GetCurrentWindow ())
If (IsRecordViewVisible ()) then
	AnnounceActivePageName ()
EndIf
EndScript

Script ControlPlusN ()
Var String cwClass
{Control + N}
Let cwClass = GetWindowClass (GetCurrentWindow ())
If (IsRecordViewVisible ()) then
	AnnounceActivePageName ()
EndIf
EndScript

Script ControlPlusC ()
Var String cwClass
{Control + C}
If (GetWindowClass (GetFocus ()) == WCField) || (GetWindowClass (GetFocus ()) == WCNotes) || (GetWindowClass (GetFocus ()) == wcEdit) then
	if GetVerbosity() == 0 then
		Say (msg027, OT_MESSAGE) ;"Copied selected text to clipboard"
		return
	EndIf
	if GetVerbosity() == 1 then
		Say (msg028, OT_MESSAGE) ;"Copied text"
	EndIf
	Return
EndIf
Let cwClass = GetWindowClass (GetCurrentWindow ())
If (IsRecordViewVisible ()) then
	AnnounceActivePageName ()
EndIf
EndScript

Script ControlPlusR ()
Var String cwClass
{Control + R}
Let cwClass = GetWindowClass (GetCurrentWindow ())
If (IsRecordViewVisible ()) then
	AnnounceActivePageName ()
EndIf
EndScript

Script ControlPlusO ()
Var String cwClass
{Control + O}
Let cwClass = GetWindowClass (GetCurrentWindow ())
If (IsRecordViewVisible ()) then
	AnnounceActivePageName ()
EndIf
EndScript

Script ControlPlusP ()
Var String cwClass
{Control + P}
Let cwClass = GetWindowClass (GetCurrentWindow ())
If (IsRecordViewVisible ()) then
	AnnounceActivePageName ()
EndIf
EndScript

Script ControlPlusH ()
Var String cwClass
{Control + H}
Let cwClass = GetWindowClass (GetCurrentWindow ())
If (IsRecordViewVisible ()) then
	AnnounceActivePageName ()
EndIf
EndScript

Script ControlPlusL ()
Var String cwClass
{Control + L}
Let cwClass = GetWindowClass (GetCurrentWindow ())
If (IsRecordViewVisible ()) then
	AnnounceActivePageName ()
EndIf
EndScript

Script ControlPlusM ()
Var String cwClass
{Control + M}
Let cwClass = GetWindowClass (GetCurrentWindow ())
If (IsRecordViewVisible ()) then
	AnnounceActivePageName ()
EndIf
EndScript

Script ControlPlusT ()
Var String cwClass
{Control + T}
Let cwClass = GetWindowClass (GetCurrentWindow ())
If (IsRecordViewVisible ()) then
	AnnounceActivePageName ()
EndIf
EndScript

Script ControlPlusY ()
Var String cwClass
{Control + Y}
Let cwClass = GetWindowClass (GetCurrentWindow ())
If (IsRecordViewVisible ()) then
	AnnounceActivePageName ()
EndIf
EndScript

Script ControlPlusJ ()
Var String cwClass
{Control + J}
Let cwClass = GetWindowClass (GetCurrentWindow ())
If (IsRecordViewVisible ()) then
	AnnounceActivePageName ()
EndIf
EndScript

Script ActionsOnTab ()
Var String cwClass
{Tab}
Let cwClass = GetWindowClass (GetCurrentWindow ())
If (IsRecordViewVisible () && IsOrgChart () == 0) then
	AnnounceActivePageName ()
EndIf
EndScript

Script ActionsOnShiftTab ()
Var String cwClass
{Shift + Tab}
Let cwClass = GetWindowClass (GetCurrentWindow ())
If (IsRecordViewVisible () && IsOrgChart () == 0) then
	AnnounceActivePageName ()
EndIf
EndScript

Script SelectAPage ()
Var String cwClass, String ItemList, Int nIndex, Handle MSTabHandle, String SearchString
Let cwClass = GetWindowClass (GetCurrentWindow ())
If (IsRecordViewVisible ()) then
	Let ItemList = RecordViewPageList
	Let nIndex = DlgSelectItemInList (ItemList, msg041, FALSE)
	If (nIndex == 1) then {Control + S} AnnounceActivePageName ()
	ElIf (nIndex == 2) then {Control + F} AnnounceActivePageName ()
	ElIf (nIndex == 3) then {Control + N} AnnounceActivePageName ()
	ElIf (nIndex == 4) then {Control + C} AnnounceActivePageName ()
	ElIf (nIndex == 5) then {Control + O} AnnounceActivePageName ()
	ElIf (nIndex == 6) then {Control + R} AnnounceActivePageName ()
	ElIf (nIndex == 7) then {Control + P} AnnounceActivePageName ()
	ElIf (nIndex == 8) then {Control + H} AnnounceActivePageName ()
	ElIf (nIndex == 9) then {Control + L} AnnounceActivePageName ()
	ElIf (nIndex == 10) then {Control + M} AnnounceActivePageName ()
	ElIf (nIndex == 11) then {Control + T} AnnounceActivePageName ()
	ElIf (nIndex == 12) then {Control + Y} AnnounceActivePageName ()
	ElIf (nIndex == 13) then {Control + J} AnnounceActivePageName () EndIf
EndIf
If (IsActivityListDialog ()) then
	Let ItemList = ActivityListPageList
	Let nIndex = DlgSelectItemInList (ItemList, msg041, FALSE)
	If (nIndex == 1) then {Control + O}
	ElIf (nIndex == 2) then {Control + E}
	ElIf (nIndex == 3) then {Control + U}
	ElIf (nIndex == 4) then {Control + C}
	ElIf (nIndex == 5) then {Control + A}
	ElIf (nIndex == 6) then {Control + F}
	ElIf (nIndex == 7) then {Control + N}
	ElIf (nIndex == 8) then {Control + T}
	ElIf (nIndex == 9) then {Control + S}
	ElIf (nIndex == 10) then {Control + I}
	ElIf (nIndex == 11) then {Control + R} EndIf
EndIf
If (IsInfoCenter ()) then
	Let ItemList = GetInfoCenterPageList (MSTabHandle)
	Let nIndex = DlgSelectItemInList (ItemList, msg041, FALSE)
	SaveCursor ()
	JAWSCursor ()
	Delay (2)
	Let nSuppressEcho = TRUE
	Let SearchString = StringSegment (ItemList, "\007", nIndex)
	If (FindString (MSTabHandle, SearchString, S_TOP, S_RESTRICTED)) then
		LeftMouseButton ()
	EndIf
	Let nSuppressEcho = FALSE
	RestoreCursor ()
EndIf
EndScript

Script SelectATool ()
Var Int ActiveToolbar, String hToolbarList, Int bSuccess, Int nToolbarType
Let bSuccess = 0
Let hToolbarList = GetActiveToolbar (ActiveToolbar)
If (ActiveToolbar == Toolbar_GettingStarted) then
	Let bSuccess = GettingStartedToolbar (StringToInt (StringSegment (hToolbarList, "\007", 1)))
	If (!bSuccess) then Say (msg034, ot_message) EndIf
ElIf (ActiveToolbar == Toolbar_Basic) then
	Let bSuccess = BasicToolbar (StringToInt (StringSegment (hToolbarList, "\007", 1)))
	If (!bSuccess) then Say (msg034, ot_message) EndIf
ElIf (ActiveToolbar == Toolbar_Standard) then
	Let bSuccess = StandardToolbar (hToolbarList)
	If (!bSuccess) then Say (msg034, ot_message) EndIf
ElIf (ActiveToolbar == Toolbar_Advanced) then
	Let bSuccess = AdvancedToolbar (hToolbarList)
	If (!bSuccess) then Say (msg034, ot_message) EndIf
Else Say (msg036, ot_message) EndIf
EndScript

Script ReadActivityCreationAndUpdatedInfo ()
Var 
	Handle pWin, Handle eWin, 
	Int nT, Int nY, Int nL, Int nR
; Store the window handle of the parent window of the current focus window
Let pWin = GetParent (GetFocus ())
;  Confirm that the current window is a part of the Activity List dialog box
If (IsActivityListDialog ()) then
;  Find the edit window that contains the notes pertaining to the selected activity.  It is a decendent window of the window pWin and has a control ID of 1016
	Let eWin = FindDescendantWindow (pWin, ID_ActivityDetail)
	If (eWin == 0) then
		Say (msg039, ot_message)
	Else
		Let nT = GetWindowTop (eWin)
		Let nL = GetWindowLeft (FindActivityListSysTabWindow ()) + 5
		Let nR = GetWindowLeft (eWin) - 5
		SaveCursor ()
		InvisibleCursor ()
		MoveTo (nL, nT)
		NextLine ()
		If (StringContains (GetLine ()	, strCreation)) then
			SayTextBetween (nL, nR)
			NextLine ()
			SayTextBetween (nL, nR)
		EndIf
		RestoreCursor ()
	EndIf
EndIf	
EndScript

Script ReadPageInformation ()
var Handle hwnd, string ThePage, String fwClass, Int nL, Int nR, Int nT, Int nB
Let hwnd = GetFocus ()
Let fwClass = GetWindowClass (hwnd)
If (IsRecordViewVisible ()) then
	Let ThePage = GetActivePageName ()
; Read notes page with pc cursor
	If (ThePage == NotesPage) then
		If (GetWindowClass (GetCurrentWindow ()) == WCField) then Return EndIf
		InvisibleCursor ()
		MoveToWindow (FindDescendantWindow (hwnd, ID_Notes))
		RoutePCToInvisible ()
		PCCursor ()
		SayAll ()
; Create a dynamic frame surrounding the fields page or the summary page and read the contents of that frame
	ElIf (ThePage == SummaryPage || ThePage == FieldsPage) then
		Let nT = GetBottomOfPageTabs () + 5
		Let nL = GetWindowLeft (hwnd)
		Let nR = GetWindowRight (hwnd)
		Let nB = GetWindowBottom (hwnd)
		SayTextBetweenTwoPoints (nL, nT, nR, nB)
	EndIf
EndIf
;  Call ReadActivityDetails if the Activity List Dialog box is active
If (IsActivityListDialog ()) then ReadActivityDetails () EndIf
EndScript

Script MoveToOrganizationChart ()
Var Handle fWin, Handle hOrgChart, Handle hOrgChartParent
;  Search through the window hierarchy to determine the window handle of the Organizational Chart and move focus to that window
; Focus Window -> First descendent window with a window class of GMOrgWnd -> Find descendent window with a control ID of 710
Let fWin = GetFocus ()
Let hOrgChartParent = FindFirstWindowWithClass (fWin, wcRecordSecondChild)
Let hOrgChart = FindDescendantWindow (hOrgChartParent, ID_OrgChart)
If (IsRecordViewVisible () && IsOrgChart () == 0) then
	If (IsOrgChartVisible () == 0) then
		Say (msg082, ot_message)
	Else
		If (GetVerbosity () == BEGINNER) then Say (msg031, ot_message) Else Say (msg032, ot_message) EndIf
		If (IsWindowVisible (hOrgChart)) then
			JAWSCursor ()
			MoveTo (GetWindowRight (hOrgChart) - 10, GetWindowTop (hOrgChart) + 10)
			LeftMouseButton ()
			PCCursor ()
		EndIf
	EndIf
ElIf (IsOrgChart () == 1) then
	Say (msg030, ot_message)
EndIf
EndScript

Script ToggleOrganizationalChart ()
{Control + Q}
If (IsRecordViewVisible ()) then
	Pause ()
	Delay (5)
	If (IsOrgChartVisible () == 1) then Say (msg042, ot_message) Else Say (msg043, ot_message) EndIf
EndIf
EndScript

Script MoveToCalendarOutline ()
Var Handle appWin, Handle fMDI, Handle fGMCal, Handle fTab, Handle fGMCo, Handle dest
;  Search through the window hierarchy to determine the window handle of the Calendar Outline and move focus to that window
; Application Main Window -> First descendent window with a window class of MDIClient -> First descendent window with a window class of GMCal -> First descendent window with a window class of SysTabControl32 -> First descendent window with a window class of GMCalOutline ->  Find descendent window with a control ID of 637
If (IsCalendar () == 0) then Return EndIf
Let appWin = GetAppMainWindow (GetFocus ())
Let fMDI = FindFirstWindowWithClass (GetFirstChild (appWin), wcRecordParent)
Let fGMCal = FindFirstWindowWithClass (GetFirstChild (fMDI),  wcCal)
Let fTab = FindFirstWindowWithClass (GetFirstChild (fGMCal), wcMsTab)
Let fGMCo = FindFirstWindowWithClass (GetFirstChild (fTab), wcCalO)
Let dest = FindDescendantWindow (fGMCo, ID_CalO)
If (dest == 0) Then Say ("Warning", ot_debug)
Else
	SaveCursor ()
	JAWSCursor ()
	MoveTo (GetWindowRight (dest) - 25, GetWindowTop (dest) + 15)
	LeftMouseButton ()
	PCCursor ()
EndIf
EndScript

Script MoveToCalendarTaskList ()
Var Handle appWin, Handle hMDI, Handle hGMCal, Handle hTab, Handle hGMCo, Handle hTask,  Handle dest
;  Search through the window hierarchy to determine the window handle of the Calendar Task List and move focus to that window
; Application Main Window -> First descendent window with a window class of MDIClient -> First descendent window with a window class of GMCal -> First descendent window with a window class of SysTabControl32 -> First descendent window with a window class of GMCalOutline -> First descendent window with a window class of CalTask -> Find descendent window with a control ID of 639
If (IsCalendar () == 0) then Return EndIf
Let appWin = GetAppMainWindow (GetFocus ())
Let hMDI = FindFirstWindowWithClass (GetFirstChild (appWin), wcRecordParent)
Let hGMCal = FindFirstWindowWithClass (GetFirstChild (hMDI),  wcCal)
Let hTab = FindFirstWindowWithClass (GetFirstChild (hGMCal), wcMsTab)
Let hGMCo = FindFirstWindowWithClass (GetFirstChild (hTab), wcCalO)
Let hTask = FindFirstWindowWithClass (GetFirstChild (hGMCo), wcCalT)
Let dest = FindDescendantWindow (hTask, ID_TaskList)
If (dest == 0) Then Say ("Warning", ot_debug)
Else
	SaveCursor ()
	JAWSCursor ()
	MoveTo (GetWindowRight (dest) - 5, GetWindowTop (dest) + 25)
	LeftMouseButton ()
	PCCursor ()
EndIf
EndScript

Script MoveToInfoCenterTreeView ()
Var Handle AppWin, Handle hMDI, Handle hInfoObj, Handle hDialog, Handle hTree, Int nW, Int nH
;  Search through the window hierarchy to determine the window handle of the InfoCenter Tree View and move focus to that window
; Application Main Window = AppWin-> First child window of AppWin = hMDI -> First child window of hMDI = hInfoObj -> First child window of hInfoObj = hDialog -> Find descendent window with a control ID of 303
If (IsInfoCenter () == 0) then Return EndIf
Let AppWin = GetAppMainWindow (GetFocus ())
Let hMDI = GetFirstChild (AppWin)
Let hInfoObj = GetFirstChild (hMDI)
Let hDialog = GetFirstChild (hInfoObj)
Let hTree = FindDescendantWindow (hDialog, ID_InfoTree)
If (hTree == 0) then Say ("Warning", ot_debug)
Else
	SaveCursor ()
	JAWSCursor ()
	Let nW = GetWindowRight (hTree) - GetWindowLeft (hTree)
	Let nH = GetWindowBottom (hTree) - GetWindowTop (hTree)
	MoveTo (GetWindowRight (hTree) - (nW/9), GetWindowTop (hTree) + (nH/70))
	LeftMouseButton ()
	RestoreCursor ()
EndIf
EndScript

Script SayDayInformation ()
Var String cwClass, String strDate, Handle appWin, Handle fMDI,
	Handle fGMCal, Handle fTab, Handle dest
If (IsCalendar () == 0) then Return EndIf
Let cwClass = GetWindowClass (GetCurrentWindow ())
If (cwClass != wcOrgChart) then Return EndIf
Let appWin = GetAppMainWindow (GetFocus ())
Let fMDI = FindFirstWindowWithClass (GetFirstChild (appWin), wcRecordParent)
Let fGMCal = FindFirstWindowWithClass (GetFirstChild (fMDI),  wcCal)
Let fTab = FindFirstWindowWithClass (GetFirstChild (fGMCal), wcMsTab)
Let dest = FindDescendantWindow (fTab, 101)
SaveCursor ()
InvisibleCursor ()
MoveToWindow (dest)
PriorWord ()
Let strDate = GetChunk ()
RestoreCursor ()
SayString (strDate)
EndScript

Script ReadPageColumns ()
Var String strText
If (GetWindowClass (GetFocus ()) == wcBrowse) then
	Let strText = GetWindowName (GetFocus ())
	If (strText == "") then
		 SaveCursor ()
		 JAWSCursor ()
		 MoveToWindow (FindBrowseWindow ())
		 Let strText = GetLine ()
		 RestoreCursor ()
	EndIf
	Say (strText, ot_message)
EndIf
EndScript

Script SayActiveRecordCompanyName ()
Var Handle AppWin, Handle hMDI, Handle hRecord, String CompanyName
If (IsRecordViewVisible () == 0) then Return EndIf
Let AppWin = GetAppMainWindow (GetFocus ())
Let hMDI = FindFirstWindowWithClass (GetFirstChild (AppWin), wcRecordParent)
Let hRecord = FindFirstWindowWithClass (GetFirstChild (hMDI), wcRecord)
SaveCursor ()
JAWSCursor ()
FindString (hRecord, "Company:", S_TOP, S_UNRESTRICTED)
NextWord ()
Let CompanyName = GetField ()
RestoreCursor ()
Say (CompanyName, ot_message)
EndScript

Script SayNextLine ()
Var  Handle hwnd
Let hwnd = GetCurrentWindow ()
If (IsCalendar () && GetWindowClass (hwnd) == wcOrgChart) then NextLine () Return EndIf
If (GetWindowClass (GetCurrentWindow ()) == wcCalLookup && IsPCCursor ()) then
	NextLine ()
	Say (GetWindowName (GetRealWindow (GetCurrentWindow ())), ot_message)
Else PerformScript SayNextLine() EndIf
EndScript

Script SayPriorLine ()
Var  Handle hwnd
Let hwnd = GetCurrentWindow ()
If (IsCalendar () && GetWindowClass (hwnd) == wcOrgChart) then PriorLine () Return EndIf
If (GetWindowClass (GetCurrentWindow ()) == wcCalLookup && IsPCCursor ()) then
	PriorLine ()
	Say (GetWindowName (GetRealWindow (GetCurrentWindow ())), ot_message)
Else PerformScript SayPriorLine() EndIf
EndScript

Script SayNextCharacter ()
Var  Handle hwnd
Let hwnd = GetCurrentWindow ()
If (IsCalendar () && GetWindowClass (hwnd) == wcOrgChart) then NextCharacter () Return EndIf
If (GetWindowClass (GetCurrentWindow ()) == wcCalLookup && IsPCCursor ()) then
	NextCharacter ()
	Say (GetWindowName (GetRealWindow (GetCurrentWindow ())), ot_message)
Else PerformScript SayNextCharacter() EndIf
EndScript

Script SayPriorCharacter ()
Var  Handle hwnd
Let hwnd = GetCurrentWindow ()
If (IsCalendar () && GetWindowClass (hwnd) == wcOrgChart) then PriorCharacter () Return EndIf
If (GetWindowClass (GetCurrentWindow ()) == wcCalLookup && IsPCCursor ()) then
	PriorCharacter ()
	Say (GetWindowName (GetRealWindow (GetCurrentWindow ())), ot_message)
Else PerformScript SayPriorCharacter() EndIf
EndScript

; GoldMine ScreenSensitiveHelp

Script ScreenSensitiveHelp ()
Var String cwClass, Handle cWin, String strPage, String fwClass, Handle rWin, String strTest, Int TheTypeCode
Let cWin  = GetCurrentWindow ()
Let cwClass = GetWindowClass (cWin)
Let fwClass = GetWindowClass (GetFocus ())
Let rWin = GetRealWindow (GetFocus ())
Let TheTypeCode = GetWindowSubTypeCode (cWin)
if (IsSameScript ()) then
	AppFileTopic()
	return
EndIf
If (IsRecordViewVisible ()) then
	If (IsOrgChart ()) then
		Say (hmsg024, ot_help)
		Say (hmsg025, ot_help)
		Say (hmsg026, ot_help)
		If (IsPCCursor ()) then
			 Say (hmsg027, ot_help)
			 Say (hmsg029, ot_help)
			 Say (hmsg030, ot_help)
			 Say (hmsg031, ot_help)
			 Say (hmsg032, ot_help)
			 Say (hmsg032a, ot_help)
			 Say (hmsg032b, ot_help)
			 Say (hmsg032c, ot_help)
		Else Say (hmsg028, ot_help) Say (GetScriptKeyName ("RightMouseButton"), ot_help) EndIf
	EndIf
	If (cwClass == wcEdit) then
	 Say (hmsg033, ot_help)
	 If (IsPCCursor ()) then
		 Say (hmsg034, ot_help)
		 delay (2)
		 Say (hmsg000 + GetScriptKeyName ("SayActiveRecordCompanyName") + hmsg035, ot_help)
		 Say (hmsg039, ot_help)
	 ElIf (IsJAWSCursor ()) then
		 Say (hmsg036 + GetScriptKeyName ("LeftMouseButton") + hmsg037 + GetScriptKeyName ("PCCursor") + hmsg038, ot_help)
		 Say (hmsg034, ot_help)
		 delay (2)
		 Say (hmsg000 + GetScriptKeyName ("SayActiveRecordCompanyName") + hmsg035, ot_help)
		 Say (hmsg039, ot_help)
	 EndIf
	EndIf
	If (cwClass == WCField) then
		Say (hmsg001, ot_help)
		Say (hmsg001a, ot_help)
		Say (hmsg002, ot_help)
		Say (hmsg003, ot_help)
		Say (hmsg004, ot_help)
	EndIf
	If (cwClass == wcNotes) then
		Say (hmsg017, ot_help)
	 If (IsPCCursor ()) then
		Say (hmsg018, ot_help)
		Say (hmsg019, ot_help)
		Say (hmsg020, ot_help)
		Say (hmsg021, ot_help)
	 ElIf (IsJAWSCursor ()) then
		Say (hmsg022, ot_help)
		Say (hmsg023, ot_help)
		Say (GetScriptKeyName ("LeftMouseButton"), ot_help)
		Say (hmsg023a, ot_help)
		Delay (2)
		Say (GetScriptKeyName ("PCCursor"), ot_help)
	 EndIf
	EndIf
	If (fwClass == wcRecord) then
		Let strPage = GetActivePageName ()
		Say (hmsg010 + " " + strPage, ot_help)
		Delay (3)
		If (strPage == SummaryPage || strPage == FieldsPage) then
		 Say (hmsg000 + GetScriptKeyName ("ReadPageInformation") + hmsg011 + strPage + hmsg011a, ot_help)
		ElIf (strPage == NotesPage) then
			Say (hmsg000 + GetScriptKeyName ("ReadPageInformation") + hmsg011 + strPage + hmsg011a, ot_help)
			Delay (3)
			Say (hmsg000a + GetScriptKeyName ("ReadPageInformation") + hmsg012, ot_help)
			Say (hmsg013, ot_help)
		EndIf
			Say (hmsg005, ot_help)
			Say (hmsg006, ot_help)
			Say (hmsg000 + GetScriptKeyName ("EditRecord") + hmsg007, ot_help)
			Say (hmsg000 + GetScriptKeyName ("SelectAPage") + hmsg008, ot_help)
			Say (hmsg000 + GetScriptKeyName ("SelectATool") + hmsg009, ot_help)
			Say (hmsg000 + GetScriptKeyName ("MoveToOrganizationChart") + hmsg009a, ot_help)
	EndIf
	If (fwClass == wcBrowse) then
		Let strPage = GetActivePageName ()
		Say (hmsg010 + " " + strPage, ot_help)
		Delay (3)
		Say (hmsg014, ot_help)
		Say (hmsg015, ot_help)
		Say (hmsg015a, ot_help)
		Say (hmsg000 + GetScriptKeyName ("ReadPageColumns") + hmsg016, ot_help)
		Say (hmsg005, ot_help)
		Say (hmsg006, ot_help)
		Say (hmsg000 + GetScriptKeyName ("EditRecord") + hmsg007, ot_help)
		Say (hmsg000 + GetScriptKeyName ("SelectAPage") + hmsg008, ot_help)
		Say (hmsg000 + GetScriptKeyName ("SelectATool") + hmsg009, ot_help)
		Say (hmsg000 + GetScriptKeyName ("MoveToOrganizationChart") + hmsg009a, ot_help)
	EndIf
	Return
ElIf (IsActivityListDialog ()) then
	Say (hmsg040 + GetActivePageName () + hmsg040a, ot_help)
	Say (hmsg000 + GetScriptKeyName ("SelectAPage") + hmsg008, ot_help)
	If (IsPCCursor ()) then
		Say (hmsg041, ot_help)
		Say (hmsg000 + GetScriptKeyName ("ReadPageInformation") + hmsg042, ot_help)
		Say (hmsg043 + hmsg043a, ot_help)
	ElIf (IsJAWSCursor ()) then
		Say (hmsg044, ot_help)
		Say (hmsg045 + GetScriptKeyName ("LeftMouseButton") + hmsg045a, ot_help)
		Say (hmsg041, ot_help)
		Say (hmsg000 + GetScriptKeyName ("ReadPageInformation") + hmsg042, ot_help)
		Say (hmsg043 + hmsg043a, ot_help)
	EndIf
	Return
ElIf (IsCalendar ()) then
	If (cwClass == wcCal) then
		Let strPage = GetCalendarPageName ()
		Say (hmsg046, ot_help)
		Say (hmsg047 +  strPage + hmsg047a, ot_help)
		If (strPage != CalO) then
			Say (hmsg048, ot_help)
		Else
			If (IsPCCursor ()) then
				Say (hmsg000 + GetScriptKeyName ("MoveToCalendarOutline") + hmsg049, ot_help)
				Say (hmsg000 + GetScriptKeyName ("MoveToCalendarTaskList") + hmsg050, ot_help)
			ElIf (IsJAWSCursor ()) then
				Say (hmsg051, ot_help)
				Say (hmsg000 + GetScriptKeyName ("MoveToCalendarOutline") + hmsg049, ot_help)
				Say (hmsg000 + GetScriptKeyName ("MoveToCalendarTaskList") + hmsg050, ot_help)
			EndIf
		EndIf
	ElIf (cwClass == wcOrgChart) then
		Say (hmsg052, ot_help)
		If (IsPCCursor ()) then
			Say (hmsg053, ot_help)
			Say (hmsg053a, ot_help)
			Say (hmsg054, ot_help)
			Say (hmsg055, ot_help)
			Say (hmsg055a, ot_help)
			Say (hmsg056, ot_help)
			Say (hmsg057, ot_help)
			Say (hmsg058, ot_help)
			Say (hmsg059, ot_help)
		ElIf (IsJAWSCursor ()) then
			Say (hmsg060, ot_help)
			Say (hmsg061, ot_help)
			Say (GetScriptKeyName ("LeftMouseButton"), ot_help)
			Say (hmsg061a, ot_help)
			Say (hmsg062, ot_help)
			Say (GetScriptKeyName ("RouteJawsCursorToPc"), ot_help)
			Say (hmsg062a, ot_help)
			Say (hmsg053, ot_help)
			Say (hmsg053a, ot_help)
			Say (hmsg054, ot_help)
			Say (hmsg055, ot_help)
			Say (hmsg055a, ot_help)
			Say (hmsg056, ot_help)
			Say (hmsg057, ot_help)
			Say (hmsg058, ot_help)
			Say (hmsg059, ot_help)
		EndIf
	ElIf (cwClass == wcList32) then
			Say (hmsg063, ot_help)
			Say (hmsg064, ot_help)
			Say (hmsg065, ot_help)

	ElIf (cwClass == wcB) then
		If (GetCurrentControlID () == ID_PDB) then
			Say (hmsg066, ot_help)
			Say (msg044, ot_help)
			Say (hmsg067, ot_help)
			Say (hmsg068, ot_help)
			Say (msg045, ot_help)
			Say (hmsg070, ot_help)
			Say (msg046, ot_help)
			Say (hmsg071, ot_help)
			Say (msg048, ot_help)
		EndIf
		If (GetCurrentControlID () == ID_TB) then
			Say (hmsg066, ot_help)
			Say (msg045, ot_message)
			Say (hmsg067, ot_help)
			Say (hmsg068, ot_help)
			Say (msg045a, ot_help)
			Say (hmsg069, ot_help)
			Say (msg044, ot_help)
			Say (hmsg070, ot_help)
			Say (msg046, ot_help)
			Say (hmsg071, ot_help)
			Say (msg044, ot_help)
		EndIf
		If (GetCurrentControlID () == ID_NDB) then
			Say (hmsg066, ot_help)
			Say (msg045a, ot_message)
			Say (hmsg067, ot_help)
			Say (hmsg068, ot_help)
			Say (msg046, ot_help)
			Say (hmsg069, ot_help)
			Say (msg045, ot_help)
			Say (hmsg070, ot_help)
			Say (msg046, ot_help)
			Say (hmsg071, ot_help)
			Say (msg044, ot_help)
		EndIf
	 If (GetCurrentControlID () == ID_SelUser) then
			Say (hmsg066, ot_help)
			Say (msg047, ot_message)
			Say (hmsg067, ot_help)
			Say (hmsg071, ot_help)
			Say (msg046, ot_message)
		EndIf
	ElIf (cwClass == wcCB) then
		If (GetCurrentControlID () == ID_UserCB) then
			Say (hmsg066, ot_help)
			Say (msg046, ot_message)
			Say (hmsg072, ot_help)
			Say (hmsg070, ot_help)
			Say (msg047, ot_help)
			Say (hmsg071, ot_help)
			Say (msg044, ot_help)
		EndIf
	EndIf
	Return
ElIf (IsCalendarDateLookup ()) then
	If (cwClass == wcCalLookup) then
			Say (hmsg083, ot_help)
			Say (hmsg084, ot_help)
			Say (hmsg085, ot_help)
	Else ScreenSensitiveHelpForKnownClasses (TheTypeCode) EndIf
	Return
ElIf (IsInfoCenter ()) then
	ScreenSensitiveHelpForKnownClasses (TheTypeCode)
	Say (hmsg000 + GetScriptKeyName ("SelectAPage") + hmsg088, ot_help)
	If (cwClass == wcOrgChart) then Say (hmsg089, ot_help)
	ElIf (cwClass == wcRE) then Say (hmsg000 + GetScriptKeyName ("MoveToInfoCenterTreeView") + hmsg090, ot_debug) EndIf
	Return
ElIf (GetWindowName (rWin) == wnSelUser) then
	If (GetWindowName (cWin) == wnUserList) then
		Say (hmsg066 + hmsg074 + hmsg073, ot_help)
		Say (hmsg077 + hmsg077a + hmsg077c, ot_help)
		Say (hmsg077d, ot_help)
		Say (hmsg078 + GetScriptKeyName ("RouteJawsCursorToPc") + hmsg078a + GetScriptKeyName ("LeftMouseButton") + hmsg078b + GetScriptKeyName ("PCCursor"), ot_help)
		Say (hmsg070 + hmsg075 + hmsg071 + hmsg082, ot_help)
	ElIf (GetCurrentControlID () == 1059) then
		Say (hmsg066 + hmsg075 + hmsg073, ot_help)
		Say (hmsg077 + hmsg077b + hmsg077c, ot_help)
		Say (hmsg077d, ot_help)
		Say (hmsg078 + GetScriptKeyName ("RouteJawsCursorToPc") + hmsg078a + GetScriptKeyName ("LeftMouseButton") + hmsg078b + GetScriptKeyName ("PCCursor"), ot_help)
		Say (hmsg070 + hmsg076 + hmsg071 + hmsg074, ot_help)
	ElIf (GetCurrentControlID () == 1151) then
		Say (hmsg066 + hmsg076 + hmsg073, ot_help)
		Say (hmsg079 + hmsg077d + hmsg079a, ot_help)
		Say (GetScriptKeyName ("RouteJawsCursorToPc") + hmsg078a + GetScriptKeyName ("LeftMouseButton") + hmsg078b + GetScriptKeyName ("PCCursor"), ot_help)
	ElIf (GetWindowClass (cWin) == wcB) then
		Say (hmsg066 + GetWindowName (cWin) + hmsg081, ot_help)
		Say (hmsg082, ot_help)
		If (GetWindowName (cWin) == wnOK) then Say (hmsg070 + wnCancel + hmsg081 + hmsg071 + hmsg076, ot_help)
		ElIf (GetWindowName (cWin) == wnCancel) then Say (hmsg070 + hmsg074 + hmsg071 + wnOK + hmsg081, ot_help) EndIf
	EndIf
	Return
Else
 ScreenSensitiveHelpForKnownClasses (TheTypeCode)
EndIf
EndScript

Void Function ScreenSensitiveHelpForKnownClasses (int nSubTypeCode)
var  int TheTypeCode, string RealName, String strTest
let theTypeCode = nSubTypeCode
if (TheTypeCode == WT_BUTTON) then ;#1
	Say (kcmsg001, ot_help) ;"This is a Button"
	Say (kcmsg002, ot_help) ;"Use enter to activate it"
	Say (kcmsg003, ot_help) ;" Use Tab to move to the next Control"
	Return
EndIf
if (TheTypeCode == WT_COMBOBOX) then ;#2
	Say (kcmsg004, ot_help) ;"This is a Combo box"
	Say (kcmsg005a, ot_help) ;"type in a value or use the arrow keys to move between the items"
	Say (kcmsg005b, ot_help); " use the arrow keys to move between the items"
	Say (kcmsg005c, ot_help); "use alt plus up arrow or Escape to close the list box"
	Say (kcmsg006, ot_help) ;"Use the Tab key to move to the next Control"
	Return
EndIf
if (TheTypeCode == WT_EDIT) then ;#3
	Say (kcmsg007, ot_help) ;"This is an edit field in which you can type information"
	Say (kcmsg008, ot_help) ;"Use the left and right arrow keys to move through the entered text"
	If (IsInfoCenter () == 0) then
		Say (kcmsg006, ot_help) ;"Use the Tab key to move to the next Control"
	EndIf
	Return
EndIf
if (TheTypeCode == WT_LISTBOX) then ;#4
	if (IsSelectScriptDlg()) then
		Say (kcmsg009, ot_help) ;"This is an execute item list box"
		Say (kcmsg017, ot_help) ;"Use the arrow keys or the first letter to move to an item"
		Say (kcmsg145, ot_help) ;"Use the space bar to toggle the selected item"
		Say (kcmsg146, ot_help) ;"Use the enter key to close this dialog"
	elif (IsSelectItemDlg()) then
		Say (kcmsg147, ot_help) ;"this is a select item list box"
		Say (kcmsg017, ot_help) ;"Use the arrow keys or the first letter to move to an item"
		Say (kcmsg148, ot_help) ;"Use enter to choose the item and exit the dialog"
		Say (kcmsg149, ot_help) ;"Use escape to cancel the dialog"
	else
		Say (kcmsg016, ot_help) ;"This is a list box"
		Let strTest = GetWindowName (GetRealWindow (GetFocus ()))
		If (StringContains (ModifyListboxWindows, strTest) == 0) then
			Say (kcmsg017, ot_help) ;"Use the arrow keys or the first letter to move to an item"
			Say (kcmsg018, ot_help) ;"Use Enter to select it"
			Say (kcmsg006, ot_help) ;"Use the Tab key to move to the next Control"
		Else
			Say (hmsg086, ot_help)
			Say (hmsg087, ot_help)
		EndIf
	endif
	Return
EndIf
if (TheTypeCode == WT_SCROLLBAR) ||
(TheTypeCode ==WT_LEFTRIGHTSCROLLBAR)
 then ;#5
	Say (kcmsg019, ot_help) ;"This is a scroll bar"
	Say (kcmsg020, ot_help) ;"Use the right arrow down arrow or page down keys to increase the value"
	Say (kcmsg021, ot_help) ;"Use the left arrow up arrow or page up keys to decrease the value"
	Say (kcmsg006, ot_help) ;"Use the Tab key to move to the next Control"
	Return
elif  (TheTypeCode ==WT_UPDOWNSCROLLBAR) Then
	Say (kcmsg142, ot_help) ;"This is an Up Down scroll bar"
	Say (kcmsg143, ot_help) ;"Use the right arrow down arrow or page down keys to decrease the value"
	Say (kcmsg144, ot_help) ;"Use the left arrow up arrow or page up keys to increase the value"
	Say (kcmsg006, ot_help) ;"Use the Tab key to move to the next Control"
EndIf
if (TheTypeCode == WT_STATIC) then ;#6
	Say (kcmsg022, ot_help) ;"This is static text for information only"
	Say (kcmsg023, ot_help) ;"Use the reading keys to read the text"
	Say (kcmsg006, ot_help) ;"Use the Tab key to move to the next Control"
	Return
EndIf
if (TheTypeCode == WT_TOOLBAR) then ;#7
	Say (kcmsg024, ot_help) ;"this is a tool bar"
	Say (kcmsg025, ot_help) ;"it contains various controls and graphics"
	Say (kcmsg026, ot_help) ;"it is generally accessed with the mouse by point and click"
	Say (kcmsg027, ot_help) ;"most tool bar items can also be found within menus"
	Return
endif
if (TheTypeCode == WT_STATUSBAR) then ;#8
	Say (kcmsg028, ot_help) ;"This is an application status bar"
	Say (kcmsg029, ot_help) ;"It provides a variety of information depending on the focus"
	Say (kcmsg030, ot_help) ;"by default jaws will read this with insert plus page down"
	Return
endif
if (TheTypeCode == WT_HEADERBAR) then ;#9
	Say (kcmsg031, ot_help) ;"This is a header bar"
	Say (kcmsg032, ot_help) ;"it contains titles for various columns below the header bar"
	Say (kcmsg033, ot_help) ;"clicking on a particular title"
	Say (kcmsg034, ot_help) ;"will generally sort the list based on the information in that column"
	Return
endif
if (TheTypeCode == WT_SPINBOX) then ;#12
	Say (kcmsg035, ot_help) ;"This is a spin box"
	Say (kcmsg036, ot_help) ;"you can edit this control manually or"
	Say (kcmsg037, ot_help) ;"arrow up or down arrow to increase or decrease its value"
	Return
endif
;WT_MENU = 13,
if (TheTypeCode == WT_MENU) then
	Say (kcmsg038, ot_help) ;"This is a menu"
	Say (kcmsg039, ot_help) ;"Use the arrow keys to move between the items"
	Say (kcmsg012, ot_help) ;"Use Say Character to read the hot key"
	Say (kcmsg013, ot_help) ;"use the hotkey as a shortcut key or"
	Say (kcmsg040, ot_help) ;"Press Enter to select the current item"
	Return
EndIf
;WT_DESKTOP = 14,
if (TheTypeCode == WT_DESKTOP) then
	Say (kcmsg041, ot_help) ;"This is the desktop"
	Say (kcmsg042, ot_help) ;"This is the area underlying all application windows"
	Return
EndIf
;WT_ICONTITLE = 16,
if (TheTypeCode == WT_ICONTITLE) then
	Say (kcmsg043, ot_help) ;"This is an Icon Title resulting from a minimized group or application"
	If (IsJAWSCursor ()) then
		Say (kcmsg044, ot_help) ;"Press the left mouse button to activate"
		Return
	EndIf
	If (IsPCCursor ()) then
		Say (kcmsg045, ot_help) ;"Press enter to activate"
		Return
	EndIf
EndIf
;WT_MDICLIENT = 17,
if (TheTypeCode == WT_MDICLIENT) then
	Say (kcmsg046, ot_help) ;"This is an multiple document interface client window"
	Say (kcmsg047, ot_help) ;"This is the space underlying documents in an m d i environment"
	 Say (hmsg091, ot_help)
	Return
EndIf
;WT_DIALOG = 18,
if (TheTypeCode == WT_DIALOG) then
	Say (kcmsg048, ot_help) ;"This is a dialog box"
	Say (kcmsg049, ot_help) ;"Use the tab keys to move between the fields"
	Return
EndIf
;WT_RADIOBUTTON = 19,
if (TheTypeCode == WT_RADIOBUTTON) then
	Say (kcmsg050, ot_help) ;"This is one of a group of radio buttons"
	Say (kcmsg051, ot_help) ;"only one can be checked at a time"
	Say (kcmsg052, ot_help) ;"Use the up and down arrow keys to move the check mark"
	Say (kcmsg006, ot_help) ;"Use the Tab key to move to the next Control"
	Return
EndIf
;WT_CHECKBOX = 20,
if (TheTypeCode == WT_CHECKBOX) then
	Say (kcmsg053, ot_help) ;"This is a check box"
	Say (kcmsg054, ot_help) ;"Use the space bar to toggle the check mark on and off"
	Say (kcmsg055, ot_help) ;"Read current line or word to read it"
	Say (kcmsg006, ot_help) ;"Use the Tab key to move to the next Control"
	Return
EndIf
;WT_GROUPBOX = 21,
if (TheTypeCode == WT_GROUPBOX) then
	Say (kcmsg056, ot_help) ;"This is a groupbox"
	If (GetVerbosity () == 0) then
		Say (kcmsg057, ot_help) ;"It is used to group items that are related"
		Say (kcmsg058, ot_help) ;"such as radio buttons"
	EndIf
	Say (kcmsg059, ot_help) ;"use the pc cursor to move between the controls"
	Return
EndIf
;WT_SDM = 23,
if (TheTypeCode == WT_SDM) then
	Say (kcmsg048, ot_help) ;"This is a dialog box"
	Say (kcmsg060, ot_help) ;"use tab and shift tab to move between the controls"
	Say (kcmsg061, ot_help) ;"select ok to accept the changes or cancel to ignore the changes"
	Return
EndIf
;WT_GENERALPICTURE= 25,
if (TheTypeCode == WT_GENERALPICTURE) then
	Say (kcmsg062, ot_help) ;"This is a General picture"
	Say (kcmsg063, ot_help) ;" functions or designs specific to the application"
	Return
EndIf
;WT_HOTKEY = 28,
if (TheTypeCode == WT_HOTKEY) then
	Say (kcmsg064, ot_help) ;"This is a hot key or short cut key edit control"
	Say (kcmsg065, ot_help) ;"be careful or you may define a short cut key by pressing any letter key"
	Say (kcmsg066, ot_help) ;"or most combinations of letter key and alt control or shift"
	Say (kcmsg067, ot_help) ;"use the tab key to move to the next control"
	Return
EndIf
;WT_TABCONTROL=29,
if (TheTypeCode == WT_TABCONTROL) then
	Say (kcmsg068, ot_help) ;"This is a tab control found in multi page dialog boxes"
	Say (kcmsg069, ot_help) ;"use the arrow keys to move between the tabs"
	Say (kcmsg070, ot_help) ;"use the tab key to move between the controls in the dialog box"
	Return
EndIf
;WT_LISTVIEW=30,
if (TheTypeCode == WT_LISTVIEW) then
	let RealName = GetWindowName (GetRealWindow (GetCurrentWindow()))
;wnDesktop="Desktop"
	if RealName == wnDesktop then
		Say (kcmsg071, ot_help) ;"This is the desktop list view"
		Say (kcmsg072, ot_help) ;"It contains shortcut icons"
		Say (kcmsg073, ot_help) ;"use the arrow keys to move from item to item"
		Say (kcmsg074, ot_help) ;"or press the first letter of the desired item"
		Say (kcmsg075, ot_help) ;"Press enter or double click to select"
		Say (kcmsg076, ot_help) ;"Press tab to move to the start button or shift + tab to move to the task bar"
		Say (kcmsg077, ot_help) ;"if the desktop items are not being read correctly"
		Say (kcmsg078, ot_help) ;"you may need to minimize all applications"
		Say (kcmsg079, ot_help) ;"this can be accomplished with insert plus f6"
		Return
	else
		Say (kcmsg080, ot_help) ;"This is a list view"
		Say (kcmsg081, ot_help) ;"use the arrow keys to read through the items"
		Say (kcmsg082, ot_help) ;"or press the first letter to jump to a desired item"
		Say (kcmsg083, ot_help) ;"items can be contained in one or more columns"
		Say (kcmsg084, ot_help) ;"to select a contiguous group of items"
		Say (kcmsg085, ot_help) ;"hold down the shift key as you arrow up or down"
		Say (kcmsg086, ot_help) ;"to select a non contiguous group of items"
		Say (kcmsg087, ot_help) ;"hold down the control key as you arrow up and down"
		Say (kcmsg088, ot_help) ;"and use control plus space bar"
		Say (kcmsg089, ot_help) ;" to select or unselect items"
		Say (kcmsg090, ot_help) ;"to here the items that have been selected"
		Say (kcmsg091, ot_help) ;"use shift plus insert plus down arrow"
		Say (kcmsg092, ot_help) ;"we recommend that you put files in a single column with all details"
		Say (kcmsg093, ot_help) ;"by selecting details from the view menu"
		Return
	EndIf
EndIf
;WT_TREEVIEW=31,
if (TheTypeCode == WT_TREEVIEW) then
	Say (kcmsg094, ot_help) ;"Tree view level "
	SayInteger (GetTreeViewLevel ())
	Say (kcmsg095, ot_help) ;"use up or down arrow to read through the items"
	Say (kcmsg096, ot_help) ;"or press the first letter to jump through the list"
	Say (kcmsg097, ot_help) ;"use the right or left arrow keys to open or close an item or"
	Say (kcmsg098, ot_help) ;"use shift with the plus or minus key"
	Say (kcmsg099, ot_help) ;"to move to the prior level press backspace"
	Say (kcmsg100, ot_help) ;"to move to the root of the tree press home"
	Say (kcmsg101, ot_help) ;"to move to the last item on the tree press end"
	Return
EndIf
;WT_STARTBUTTON=32,
if (TheTypeCode == WT_STARTBUTTON) then
	Say (kcmsg102, ot_help) ;"This is the start button"
	Say (kcmsg103, ot_help) ;"Press Enter to open the start menu"
	Say (kcmsg104, ot_help) ;"items in the start menu are used to launch applications"
	Say (kcmsg105, ot_help) ;"or tab to move to the task bar"
	Say (kcmsg106, ot_help) ;"you can use control plus escape to activate this menu at any time"
	Return
EndIf
;WT_STARTMENU=33,
if (TheTypeCode == WT_STARTMENU) then
	Say (kcmsg107, ot_help) ;"This is the start menu"
	Say (kcmsg108, ot_help) ;"items in this menu are used to launch applications"
	Say (kcmsg109, ot_help) ;"Use up or down arrow to move between the items"
	Say (kcmsg012, ot_help) ;"Use Say Character to read the hot key"
	Say (kcmsg040, ot_help) ;"Press Enter to select the current item"
	Return
EndIf
;WT_CONTEXTMENU=34,
if (TheTypeCode == WT_CONTEXTMENU) then
	Say (kcmsg110, ot_help) ;"This is the context menu"
	Say (kcmsg109, ot_help) ;"Use up or down arrow to move between the items"
	Say (kcmsg012, ot_help) ;"Use Say Character to read the hot key"
	Say (kcmsg040, ot_help) ;"Press Enter to select the current item"
	Return
EndIf
;WT_task bar=35
if (TheTypeCode == WT_TASKBAR) then
	Say (kcmsg111, ot_help) ;"This is the task bar"
	Say (kcmsg112, ot_help) ;" it contains the currently running applications"
	Say (kcmsg069, ot_help) ;"use the arrow keys to move between the tabs"
	Say (kcmsg113, ot_help) ;" use enter to invoke the application"
	Say (kcmsg114, ot_help)	 ;"use alt plus enter to open the task bar properties dialog"
	Say (kcmsg115, ot_help) ;"use the tab key to move to the desktop"
	Return
EndIf
;WT_MULTISELECT_LISTBOX=37,
if (TheTypeCode == WT_MULTISELECT_LISTBOX) then
	Say (kcmsg116, ot_help) ;"This is a multiselect listbox"
	Say (kcmsg084, ot_help) ;"to select a contiguous group of items"
	Say (kcmsg117, ot_help) ;"hold down the shift key as you arrow up and down"
	Say (kcmsg086, ot_help) ;"to select a non contiguous group of items"
	Say (kcmsg087, ot_help) ;"hold down the control key as you arrow up and down"
	Say (kcmsg118, ot_help) ;"and use the space bar to select the item"
	Say (kcmsg090, ot_help) ;"to here the items that have been selected"
	Say (kcmsg091, ot_help) ;"use shift plus insert plus down arrow"
	Return
endif
;WT_EXTENDEDSELECT_LISTBOX=38,
if (TheTypeCode == WT_EXTENDEDSELECT_LISTBOX) then
	Say (kcmsg119, ot_help) ;"This is an extended select list box"
	Say (kcmsg084, ot_help) ;"to select a contiguous group of items"
	Say (kcmsg117, ot_help) ;"hold down the shift key as you arrow up and down"
	Say (kcmsg120, ot_help) ;"use shift + f8 to toggle the extended select option"
	Say (kcmsg121, ot_help) ;"When the extended select option is on"
	Say (kcmsg122, ot_help) ;"you can select multiple items with your space bar"
	Say (kcmsg090, ot_help) ;"to here the items that have been selected"
	Say (kcmsg091, ot_help) ;"use shift plus insert plus down arrow"
	Return
endif
if (TheTypeCode == WT_LEFTRIGHTSLIDER) then ;#39
	Say (kcmsg123, ot_help) ;"This is a horizontal slider"
	Say (kcmsg124, ot_help) ;"the value of the control increases as you move to the right"
	Say (kcmsg125, ot_help) ;"this type of control is frequently used to control settings such as"
	Say (kcmsg126, ot_help) ;"volume or pitch"
	Return
endif
if (TheTypeCode == WT_UPDOWNSLIDER) then ;#40
	Say (kcmsg127, ot_help) ;"This is a vertical slider"
	Say (kcmsg128, ot_help) ;"the value of the control increases as you move upward"
	Say (kcmsg125, ot_help) ;"this type of control is frequently used to control settings such as"
	Say (kcmsg126, ot_help) ;"volume or pitch"
	Return
endif
;WT_EDITCOMBO = 41
if (TheTypeCode == WT_EDITCOMBO) then ;#41
	Say (kcmsg129, ot_help) ;"This is an edit Combo box"
	Say (kcmsg005, ot_help) ;"type in a value or use alt plus down arrow to open the list box"
	Say (kcmsg005b, ot_help); " use the arrow keys to move between the items"
	Say (kcmsg005c, ot_help); "use alt plus up arrow or Escape to close the list box"
	Say (kcmsg006, ot_help) ;"Use the Tab key to move to the next Control"
	Say (kcmsg150, ot_help) ;" previously selected items"
	Return
endif
;WT_PASSWORDEDIT=42,
if (TheTypeCode == WT_PASSWORDEDIT) then ;#42
	Say (kcmsg130, ot_help) ;"This is a password edit control"
	Say (kcmsg151, ot_help) ;" visually replaced by asteriks"
	Say (kcmsg131, ot_help) ;"Use the backspace to delete and start over"
	Say (kcmsg006, ot_help) ;"Use the Tab key to move to the next Control"
	Return
endif
if (TheTypeCode == WT_READONLYEDIT) then ;#43
	Say (kcmsg132, ot_help) ;"This text is reed only"
	Say (kcmsg133, ot_help) ;"you can navigate and read text with the jaws cursor"
	Say (kcmsg134, ot_help) ;"but you cannot edit the text"
	Return
endif
if (theTypeCode == WT_COMMANDBAR) then ;#44
	Say (kcmsg136, ot_help);"This is a command bar"
	Say (kcmsg137, ot_help);"it consists of a row of buttons"
	Say (kcmsg138, ot_help) ;"you can arrow left or right to hear the different button names"
	Say (kcmsg139, ot_help) ;"and press enter to activate a button"
	Say (kcmsg140, ot_help) ;"press control plus tab to move to the next command bar"
	Say (kcmsg141, ot_help) ;"press escape to leave the command bar"
	return
endif
if (GlobalMenuMode == MENUBAR_ACTIVE) then
	Say (kcmsg010, ot_help) ;"This is the menu bar"
	Say (kcmsg011, ot_help) ;"you can arrow left and right to hear the different menu names"
	Say (kcmsg012, ot_help) ;"Use Say Character to read the hot key"
	Say (kcmsg013, ot_help) ;"use the hotkey as a shortcut key or"
	Say (kcmsg014, ot_help) ;"press enter or down arrow to open a menu"
	Say (kcmsg015, ot_help) ;"press escape to exit the menu bar"
	return
endif
;if it gets this far it did not recognize the type code.
Say (kcmsg135, ot_help) ;"The Type Code is"
SayInteger (TheTypeCode)
ScreenSensitiveHelpForUnknownClasses (); catch everything not yet handled
EndFunction

Script HotKeyHelp ()
; To add keystrokes to HotKeyHelp, add them in the appropriate section(s) of SayGoldMineHotKeys
SayExtendedHelpHotKey ()
Say (hkmsg001 + GetScriptKeyName ("SelectATool"), OT_HELP) ; "To access the buttons in the GoldMine ToolBar, press"
If (GetWindowClass (GetParent (GetFocus ())) == WCDialog) then
	PerformScript HotKeyHelp()
	Return
EndIf
SayGoldMineHotKeys ()
EndScript

Void Function SayGoldMineHotKeys ()
; Hot Key Help calls this function.
; It is separated into sections so as to make it easier for the hot keys you add to be spoken relative to the active window.
var handle hwnd, string TheClass
let hwnd = GetCurrentWindow ()
let TheClass = GetWindowClass (hwnd)
If (IsRecordViewVisible () && IsOrgChart () == 0) then
	Say (hkmsg001a + GetScriptKeyName ("SelectAPage"), ot_help)
	Say (hkmsg002a, ot_help)
	Say (hkmsg002, ot_help)
	Say (hkmsg003, ot_help)
	Say (hkmsg004, ot_help)
	Say (hkmsg005, ot_help)
	Say (hkmsg006, ot_help)
	Say (hkmsg007, ot_help)
	Say (hkmsg008, ot_help)
	Say (hkmsg009, ot_help)
	Say (hkmsg010, ot_help)
	Say (hkmsg011, ot_help)
	Say (hkmsg012, ot_help)
	Say (hkmsg013, ot_help)
	Say (hkmsg014, ot_help)
	Say (hmsg000 + GetScriptKeyName ("PreviousRecord") + hkmsg014a, ot_help)
	Say (hmsg000 + GetScriptKeyName ("NextRecord") + hkmsg014b, ot_help)
	Say (hmsg000 + GetScriptKeyName ("LastViewedRecord") + hkmsg014c, ot_help)
	Say (hmsg000 + GetScriptKeyName ("FirstRecord") + hkmsg014d, ot_help)
	Say (hmsg000 + GetScriptKeyName ("LastRecord") + hkmsg014e, ot_help)
	Say (hmsg000 + GetScriptKeyName ("EditRecord") + hkmsg015, ot_help)
	If (GetActivePageName () == FieldsPage || GetActivePageName () == SummaryPage || GetActivePageName () == NotesPage) then
		Say (hmsg000 + GetScriptKeyName ("ReadPageInformation") + hkmsg015a, ot_help)
	EndIf
	Say (hkmsg016, ot_help)
	Say (hkmsg017, ot_help)
	Say (hmsg000 + GetScriptKeyName ("ToggleOrganizationalChart") + hkmsg018, ot_help)
	Say (hmsg000 + GetScriptKeyName ("MoveToOrganizationChart") + hkmsg019, ot_help)
ElIf (IsOrgChart ()) then
	Say (hkmsg020, ot_help)
	Say (hkmsg020a, ot_help)
	Say (hkmsg021, ot_help)
ElIf (IsCalendar ()) then
	If (GetCalendarPageName () != CalO) then Say (hkmsg022, ot_help) EndIf
	If (GetCalendarPageName () == CalO) then
		If (TheClass != wcOrgChart) then Say (hmsg000 + GetScriptKeyName ("MoveToCalendarOutline") + hkmsg023, ot_help) EndIf
		If (TheClass != wcList32) then  Say (hmsg000 + GetScriptKeyName ("MoveToCalendarTaskList") + hkmsg024, ot_help) EndIf
		If (TheClass == wcOrgChart) then Say (hkmsg025, ot_help) EndIf
	EndIf
ElIf (IsInfoCenter ()) then
	Say (hkmsg001a + GetScriptKeyName ("SelectAPage"), ot_help)
	If (TheClass != wcRE) then Say (hkmsg025, ot_help) EndIf
	If (TheClass == wcRE) then Say (hkmsg026, ot_help) EndIf
ElIf (IsActivityListDialog ()) then
	Say (hkmsg027, ot_help)
	Say (hkmsg028, ot_help)
	Say (hkmsg029, ot_help)
	Say (hkmsg030, ot_help)
	Say (hkmsg031, ot_help)
	Say (hkmsg032, ot_help)
	Say (hkmsg033, ot_help)
	Say (hkmsg034, ot_help)
	Say (hkmsg035, ot_help)
	Say (hkmsg036, ot_help)
	Say (hkmsg037, ot_help)
	Say (hmsg000 + GetScriptKeyName ("ReadPageInformation") + hkmsg038, ot_help)
EndIf
EndFunction

Script ActivateFieldsPageInEditRecordMode ()
Var
	String curWinClass
Let curWinClass = GetWindowClass (GetCurrentWindow ())
If (IsRecordViewVisible ()) then
	If (curWinClass != WCField) then
		{Control + F}
		AnnounceActivePageName ()
		PerformScript EditRecord()
	ElIf (curWinClass == WCField) then
		{escape}
		{Control + F}
		AnnounceActivePageName ()
		PerformScript EditRecord()
	EndIf
Else
	{F6}
EndIf
EndScript

Script MoveToFirstControlInFieldsPage ()
Var 
	String curWinClass, Int nY, Int nX, 
	Int nX_diff, Int nY_diff
If (IsRecordViewVisible ()) then
	Let curWinClass = GetWindowClass (GetCurrentWindow ())
	If (curWinClass == WCField) then
		{Escape}
		Delay (1)
		{Control + F}
		Delay (1)
	ElIf (curWinClass != WCField) then
		{Control + F}
	EndIf
	Let nSuppressEcho = TRUE
	Let nX_diff = (GetWindowRight (FindRecordWindow ()) - GetWindowLeft (FindRecordWindow ())) / 20
	Let nY_diff = (GetBottomOfPageTabs () - GetWindowTop (FindRecordWindow ())) / 5
	Let nX = GetWindowRight (FindRecordWindow ()) - nX_diff
	Let nY = GetBottomOfPageTabs () - nY_diff
	SaveCursor ()
	JAWSCursor ()
	MoveTo (nX, nY)
	LeftMouseButton()
	RestoreCursor ()
	{Tab}
	ScheduleFunction ("ResetnSuppressEcho", 5)
Else
	{Control+F7}
EndIf
EndScript

Script ActivateSummaryPageInEditRecordMode ()
Var
	String curWinClass
Let curWinClass = GetWindowClass (GetCurrentWindow ())
If (IsRecordViewVisible ()) then
	If (curWinClass != WCField) then
		{Control + S}
		AnnounceActivePageName ()
		PerformScript EditRecord()
	ElIf (curWinClass == WCField) then
		{escape}
		{Control + S}
		AnnounceActivePageName ()
		PerformScript EditRecord()
	EndIf
Else
	{F7}
EndIf
EndScript

Script MoveToFirstControlInSummaryPage ()
Var 
	String curWinClass, Int nY, Int nX, 
	Int nX_diff, Int nY_diff
If (IsRecordViewVisible ()) then
	Let curWinClass = GetWindowClass (GetCurrentWindow ())
	If (curWinClass == WCField) then
		{Escape}
		Delay (1)
		{Control + S}
		Delay (1)
	ElIf (curWinClass != WCField) then
		{Control + S}
	EndIf
	Let nSuppressEcho = TRUE
	Let nX_diff = (GetWindowRight (FindRecordWindow ()) - GetWindowLeft (FindRecordWindow ())) / 20
	Let nY_diff = (GetBottomOfPageTabs () - GetWindowTop (FindRecordWindow ())) / 5
	Let nX = GetWindowRight (FindRecordWindow ()) - nX_diff
	Let nY = GetBottomOfPageTabs () - nY_diff
	SaveCursor ()
	JAWSCursor ()
	MoveTo (nX, nY)
	LeftMouseButton()
	RestoreCursor ()
	{Tab}
	ScheduleFunction ("ResetnSuppressEcho", 5)
Else
	{Control+F7}
EndIf
EndScript

